/*
 * Decompiled with CFR 0.152.
 */
package org.skife.config;

public enum DataAmountUnit {
    BYTE("B", 1L),
    KIBIBYTE("KiB", 1024L),
    MEBIBYTE("MiB", 0x100000L),
    GIBIBYTE("GiB", 0x40000000L),
    TEBIBYTE("TiB", 0x10000000000L),
    PEBIBYTE("PiB", 0x4000000000000L),
    EXIBYTE("EiB", 0x1000000000000000L),
    KILOBYTE("kB", 1000L),
    MEGABYTE("MB", 1000000L),
    GIGABYTE("GB", 1000000000L),
    TERABYTE("TB", 1000000000000L),
    PETABYTE("PB", 1000000000000000L),
    EXABYTE("EB", 1000000000000000000L);

    private final String symbol;
    private final long factor;

    private DataAmountUnit(String symbol, long factor) {
        this.symbol = symbol;
        this.factor = factor;
    }

    public static DataAmountUnit fromString(String text) {
        for (DataAmountUnit unit : DataAmountUnit.values()) {
            if (!unit.symbol.equals(text)) continue;
            return unit;
        }
        throw new IllegalArgumentException("Unknown unit '" + text + "'");
    }

    public static DataAmountUnit fromStringCaseInsensitive(String origText) {
        String text = origText.toLowerCase();
        for (DataAmountUnit unit : DataAmountUnit.values()) {
            if (!unit.symbol.equals(text)) continue;
            return unit;
        }
        throw new IllegalArgumentException("Unknown unit '" + origText + "'");
    }

    public String getSymbol() {
        return this.symbol;
    }

    public long getFactor() {
        return this.factor;
    }
}

