/*
 * Decompiled with CFR 0.152.
 */
package org.skife.config;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.skife.config.Bully;
import org.skife.config.Coercible;
import org.skife.config.Config;
import org.skife.config.ConfigReplacements;
import org.skife.config.ConfigSource;
import org.skife.config.Default;
import org.skife.config.DefaultNull;
import org.skife.config.Param;
import org.skife.config.Separator;
import org.skife.config.SimplePropertyConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationObjectFactory.class);
    private final ConfigSource config;
    private final Bully bully;

    public ConfigurationObjectFactory(Properties props) {
        this(new SimplePropertyConfigSource(props));
    }

    public ConfigurationObjectFactory(ConfigSource config) {
        this.config = config;
        this.bully = new Bully();
    }

    public void addCoercible(Coercible<?> coercible) {
        this.bully.addCoercible(coercible);
    }

    public <T> T buildWithReplacements(Class<T> configClass, Map<String, String> mappedReplacements) {
        return this.internalBuild(configClass, mappedReplacements);
    }

    public <T> T build(Class<T> configClass) {
        return this.internalBuild(configClass, null);
    }

    private <T> T internalBuild(Class<T> configClass, @Nullable Map<String, String> mappedReplacements) {
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition bbBuilder = new ByteBuddy().subclass(configClass);
        for (Method method : configClass.getMethods()) {
            Annotation annotation;
            if (method.isAnnotationPresent(Config.class)) {
                annotation = method.getAnnotation(Config.class);
                if (method.getParameterTypes().length > 0) {
                    if (mappedReplacements != null) {
                        throw new RuntimeException("Replacements are not supported for parameterized config methods");
                    }
                    bbBuilder = this.buildParameterized((DynamicType.Builder<T>)bbBuilder, method, (Config)annotation);
                    continue;
                }
                bbBuilder = this.buildSimple((DynamicType.Builder<T>)bbBuilder, method, (Config)annotation, mappedReplacements, null);
                continue;
            }
            if (method.isAnnotationPresent(ConfigReplacements.class)) {
                annotation = method.getAnnotation(ConfigReplacements.class);
                if ("__%%%noValue%%%__".equals(annotation.value())) {
                    Map<Object, Object> fixedMap = mappedReplacements == null ? Collections.emptyMap() : Collections.unmodifiableMap(mappedReplacements);
                    bbBuilder = bbBuilder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)FixedValue.value(fixedMap));
                    continue;
                }
                bbBuilder = this.buildSimple((DynamicType.Builder<T>)bbBuilder, method, null, mappedReplacements, (ConfigReplacements)annotation);
                continue;
            }
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            throw new AbstractMethodError(String.format("Method [%s] is abstract and lacks an @Config annotation", method.toGenericString()));
        }
        Class loaded = bbBuilder.make().load(configClass.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
        try {
            return configClass.cast(loaded.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError("Failed to instantiate proxy class for " + configClass.getName(), e);
        }
    }

    private <T> DynamicType.Builder<T> buildSimple(DynamicType.Builder<T> bbBuilder, Method method, Config annotation, Map<String, String> mappedReplacements, ConfigReplacements mapAnnotation) {
        String[] propertyNames = new String[]{};
        String value = null;
        if (annotation != null) {
            propertyNames = annotation.value();
            if (propertyNames.length == 0) {
                throw new IllegalArgumentException("Method " + method.toGenericString() + " declares config annotation but no field name!");
            }
            for (String propertyName : propertyNames) {
                if (mappedReplacements != null) {
                    propertyName = this.applyReplacements(propertyName, mappedReplacements);
                }
                if ((value = this.config.getString(propertyName)) == null) continue;
                logger.info("Assigning value [{}] for [{}] on [{}#{}()]", new Object[]{value, propertyName, method.getDeclaringClass().getName(), method.getName()});
                break;
            }
        } else {
            if (mapAnnotation == null) {
                throw new IllegalStateException("Neither @Config nor @ConfigReplacements provided, this should not be possible!");
            }
            String key = mapAnnotation.value();
            String string = value = mappedReplacements == null ? null : mappedReplacements.get(key);
            if (value != null) {
                logger.info("Assigning mappedReplacement value [{}] for [{}] on [{}#{}()]", new Object[]{value, key, method.getDeclaringClass().getName(), method.getName()});
            }
        }
        boolean hasDefault = method.isAnnotationPresent(Default.class);
        boolean hasDefaultNull = method.isAnnotationPresent(DefaultNull.class);
        if (hasDefault && hasDefaultNull) {
            throw new IllegalArgumentException(String.format("@Default and @DefaultNull present in [%s]", method.toGenericString()));
        }
        boolean useMethod = false;
        if (value == null) {
            if (hasDefault) {
                value = method.getAnnotation(Default.class).value();
                logger.info("Assigning default value [{}] for {} on [{}#{}()]", new Object[]{value, propertyNames, method.getDeclaringClass().getName(), method.getName()});
            } else if (hasDefaultNull) {
                logger.info("Assigning null default value for {} on [{}#{}()]", new Object[]{propertyNames, method.getDeclaringClass().getName(), method.getName()});
            } else if (!Modifier.isAbstract(method.getModifiers())) {
                useMethod = true;
                logger.info("Using method itself for {} on [{}#{}()]", new Object[]{propertyNames, method.getDeclaringClass().getName(), method.getName()});
            } else {
                throw new IllegalArgumentException(String.format("No value present for '%s' in [%s]", this.prettyPrint(propertyNames, mappedReplacements), method.toGenericString()));
            }
        }
        if (useMethod) {
            return bbBuilder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)SuperMethodCall.INSTANCE);
        }
        if (value == null) {
            return bbBuilder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept(FixedValue.nullValue());
        }
        Object finalValue = this.bully.coerce(method.getGenericReturnType(), value, method.getAnnotation(Separator.class));
        return bbBuilder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)FixedValue.value((Object)finalValue));
    }

    private String applyReplacements(String propertyName, Map<String, String> mappedReplacements) {
        for (Map.Entry<String, String> entry : mappedReplacements.entrySet()) {
            String token = this.makeToken(entry.getKey());
            String replacement = entry.getValue();
            propertyName = propertyName.replace(token, replacement);
        }
        return propertyName;
    }

    private <T> DynamicType.Builder<T> buildParameterized(DynamicType.Builder<T> bbBuilder, Method method, Config annotation) {
        String defaultValue = null;
        boolean hasDefault = method.isAnnotationPresent(Default.class);
        boolean hasDefaultNull = method.isAnnotationPresent(DefaultNull.class);
        if (hasDefault && hasDefaultNull) {
            throw new IllegalArgumentException(String.format("@Default and @DefaultNull present in [%s]", method.toGenericString()));
        }
        if (hasDefault) {
            defaultValue = method.getAnnotation(Default.class).value();
        } else if (!hasDefaultNull) {
            throw new IllegalArgumentException(String.format("No value present for '%s' in [%s]", this.prettyPrint(annotation.value(), null), method.toGenericString()));
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<String> paramTokenList = new ArrayList<String>();
        Annotation[][] annotationArray = parameterAnnotations;
        int n = annotationArray.length;
        block0: for (int i = 0; i < n; ++i) {
            Annotation[] parameterTab;
            for (Annotation parameter : parameterTab = annotationArray[i]) {
                if (!parameter.annotationType().equals(Param.class)) continue;
                Param paramAnnotation = (Param)parameter;
                paramTokenList.add(this.makeToken(paramAnnotation.value()));
                continue block0;
            }
        }
        if (paramTokenList.size() != method.getParameterTypes().length) {
            throw new RuntimeException(String.format("Method [%s] is missing one or more @Param annotations", method.toGenericString()));
        }
        Object bulliedDefaultValue = this.bully.coerce(method.getGenericReturnType(), defaultValue, method.getAnnotation(Separator.class));
        String[] annotationValues = annotation.value();
        if (annotationValues.length == 0) {
            throw new IllegalArgumentException("Method " + method.toGenericString() + " declares config annotation but no field name!");
        }
        ConfigMagicMethodInterceptor invocationHandler = new ConfigMagicMethodInterceptor(method, this.config, annotationValues, paramTokenList, this.bully, bulliedDefaultValue);
        return bbBuilder.method((ElementMatcher)ElementMatchers.is((Method)method)).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)invocationHandler));
    }

    private String makeToken(String temp) {
        return "${" + temp + "}";
    }

    private String prettyPrint(String[] values, Map<String, String> mappedReplacements) {
        int i;
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        for (i = 0; i < values.length; ++i) {
            sb.append(values[i]);
            if (i >= values.length - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        if (mappedReplacements != null && !mappedReplacements.isEmpty()) {
            sb.append(" translated to [");
            for (i = 0; i < values.length; ++i) {
                sb.append(this.applyReplacements(values[i], mappedReplacements));
                if (i >= values.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private static final class ConfigMagicMethodInterceptor
    implements InvocationHandler {
        private final Method method;
        private final ConfigSource config;
        private final String[] properties;
        private final Bully bully;
        private final Object defaultValue;
        private final List<String> paramTokenList;
        private transient String toStringValue = null;

        private ConfigMagicMethodInterceptor(Method method, ConfigSource config, String[] properties, List<String> paramTokenList, Bully bully, Object defaultValue) {
            this.method = method;
            this.config = config;
            this.properties = properties;
            this.paramTokenList = paramTokenList;
            this.bully = bully;
            this.defaultValue = defaultValue;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] args) {
            for (String property : this.properties) {
                if (args.length == this.paramTokenList.size()) {
                    for (int i = 0; i < args.length; ++i) {
                        property = property.replace(this.paramTokenList.get(i), String.valueOf(args[i]));
                    }
                    String value = this.config.getString(property);
                    if (value == null) continue;
                    logger.info("Assigning value [{}] for [{}] on [{}#{}()]", new Object[]{value, property, method.getDeclaringClass().getName(), method.getName()});
                    return this.bully.coerce(method.getGenericReturnType(), value, method.getAnnotation(Separator.class));
                }
                throw new IllegalStateException("Argument list doesn't match @Param list");
            }
            logger.info("Assigning default value [{}] for {} on [{}#{}()]", new Object[]{this.defaultValue, this.properties, method.getDeclaringClass().getName(), method.getName()});
            return this.defaultValue;
        }

        public String toString() {
            if (this.toStringValue == null) {
                this.toStringValue = this.method.getName() + ": " + super.toString();
            }
            return this.toStringValue;
        }
    }
}

