/*
 * Decompiled with CFR 0.152.
 */
package org.skife.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.skife.config.CaseInsensitiveEnumCoercible;
import org.skife.config.Coercer;
import org.skife.config.Coercible;

final class DefaultCoercibles {
    public static final Coercible<?> CASE_INSENSITIVE_ENUM_COERCIBLE = new CaseInsensitiveEnumCoercible();
    static final Coercible<?> VALUE_OF_COERCIBLE = new Coercible<Object>(){
        private final Map<Class<?>, Coercer<Object>> coercerMap = new HashMap();

        @Override
        public Coercer<Object> accept(Class<?> type) {
            if (this.coercerMap.containsKey(type)) {
                return this.coercerMap.get(type);
            }
            Coercer<Object> coercer = null;
            try {
                Method candidate = type.getMethod("valueOf", String.class);
                if (!Modifier.isStatic(candidate.getModifiers())) {
                    candidate = null;
                } else if (!candidate.getReturnType().isAssignableFrom(type)) {
                    candidate = null;
                }
                if (candidate != null) {
                    final Method valueOfMethod = candidate;
                    coercer = new Coercer<Object>(){

                        @Override
                        public Object coerce(String value) {
                            try {
                                return value == null ? null : valueOfMethod.invoke(null, value);
                            }
                            catch (Exception e) {
                                throw DefaultCoercibles.convertException(e);
                            }
                        }
                    };
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.coercerMap.put(type, coercer);
            return coercer;
        }
    };
    static final Coercible<?> STRING_CTOR_COERCIBLE = new Coercible<Object>(){
        private final Map<Class<?>, Coercer<Object>> coercerMap = new HashMap();

        @Override
        public Coercer<Object> accept(Class<?> type) {
            if (this.coercerMap.containsKey(type)) {
                return this.coercerMap.get(type);
            }
            Coercer<Object> coercer = null;
            try {
                final Constructor<?> ctor = type.getConstructor(String.class);
                coercer = new Coercer<Object>(){

                    @Override
                    public Object coerce(String value) {
                        try {
                            return value == null ? null : ctor.newInstance(value);
                        }
                        catch (Exception e) {
                            throw DefaultCoercibles.convertException(e);
                        }
                    }
                };
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.coercerMap.put(type, coercer);
            return coercer;
        }
    };
    static final Coercible<?> OBJECT_CTOR_COERCIBLE = new Coercible<Object>(){
        private final Map<Class<?>, Coercer<Object>> coercerMap = new HashMap();

        @Override
        public Coercer<Object> accept(Class<?> type) {
            if (this.coercerMap.containsKey(type)) {
                return this.coercerMap.get(type);
            }
            Coercer<Object> coercer = null;
            try {
                final Constructor<?> ctor = type.getConstructor(Object.class);
                coercer = new Coercer<Object>(){

                    @Override
                    public Object coerce(String value) {
                        try {
                            return ctor.newInstance(value);
                        }
                        catch (Exception e) {
                            throw DefaultCoercibles.convertException(e);
                        }
                    }
                };
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.coercerMap.put(type, coercer);
            return coercer;
        }
    };
    static final Coercer<Boolean> BOOLEAN_COERCER = new Coercer<Boolean>(){

        @Override
        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Using annotation because cannot excluded via xml")
        public Boolean coerce(String value) {
            return value != null ? Boolean.valueOf(value) : null;
        }
    };
    static final Coercible<Boolean> BOOLEAN_COERCIBLE = new Coercible<Boolean>(){

        @Override
        public Coercer<Boolean> accept(Class<?> clazz) {
            if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
                return BOOLEAN_COERCER;
            }
            return null;
        }
    };
    static final Coercer<Byte> BYTE_COERCER = new Coercer<Byte>(){

        @Override
        public Byte coerce(String value) {
            return value != null ? Byte.valueOf(value) : null;
        }
    };
    static final Coercible<Byte> BYTE_COERCIBLE = new Coercible<Byte>(){

        @Override
        public Coercer<Byte> accept(Class<?> clazz) {
            if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
                return BYTE_COERCER;
            }
            return null;
        }
    };
    static final Coercer<Short> SHORT_COERCER = new Coercer<Short>(){

        @Override
        public Short coerce(String value) {
            return value != null ? Short.valueOf(value) : null;
        }
    };
    static final Coercible<Short> SHORT_COERCIBLE = new Coercible<Short>(){

        @Override
        public Coercer<Short> accept(Class<?> clazz) {
            if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
                return SHORT_COERCER;
            }
            return null;
        }
    };
    static final Coercer<Integer> INTEGER_COERCER = new Coercer<Integer>(){

        @Override
        public Integer coerce(String value) {
            return value != null ? Integer.valueOf(value) : null;
        }
    };
    static final Coercible<Integer> INTEGER_COERCIBLE = new Coercible<Integer>(){

        @Override
        public Coercer<Integer> accept(Class<?> clazz) {
            if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
                return INTEGER_COERCER;
            }
            return null;
        }
    };
    static final Coercer<Long> LONG_COERCER = new Coercer<Long>(){

        @Override
        public Long coerce(String value) {
            return value != null ? Long.valueOf(value) : null;
        }
    };
    static final Coercible<Long> LONG_COERCIBLE = new Coercible<Long>(){

        @Override
        public Coercer<Long> accept(Class<?> clazz) {
            if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
                return LONG_COERCER;
            }
            return null;
        }
    };
    static final Coercer<Float> FLOAT_COERCER = new Coercer<Float>(){

        @Override
        public Float coerce(String value) {
            return value != null ? Float.valueOf(value) : null;
        }
    };
    static final Coercible<Float> FLOAT_COERCIBLE = new Coercible<Float>(){

        @Override
        public Coercer<Float> accept(Class<?> clazz) {
            if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
                return FLOAT_COERCER;
            }
            return null;
        }
    };
    static final Coercer<Double> DOUBLE_COERCER = new Coercer<Double>(){

        @Override
        public Double coerce(String value) {
            return value != null ? Double.valueOf(value) : null;
        }
    };
    static final Coercible<Double> DOUBLE_COERCIBLE = new Coercible<Double>(){

        @Override
        public Coercer<Double> accept(Class<?> clazz) {
            if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
                return DOUBLE_COERCER;
            }
            return null;
        }
    };
    static final Coercer<String> STRING_COERCER = new Coercer<String>(){

        @Override
        public String coerce(String value) {
            return value;
        }
    };
    static final Coercible<String> STRING_COERCIBLE = new Coercible<String>(){

        @Override
        public Coercer<String> accept(Class<?> clazz) {
            if (String.class.equals(clazz)) {
                return STRING_COERCER;
            }
            return null;
        }
    };
    static final Coercer<URI> URI_COERCER = new Coercer<URI>(){

        @Override
        public URI coerce(String value) {
            return value != null ? URI.create(value) : null;
        }
    };
    static final Coercible<URI> URI_COERCIBLE = new Coercible<URI>(){

        @Override
        public Coercer<URI> accept(Class<?> clazz) {
            if (URI.class.equals(clazz)) {
                return URI_COERCER;
            }
            return null;
        }
    };

    private DefaultCoercibles() {
    }

    public static final RuntimeException convertException(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof InvocationTargetException) {
            return DefaultCoercibles.convertException(((InvocationTargetException)t).getTargetException());
        }
        return new RuntimeException(t);
    }
}

