/*
 * Decompiled with CFR 0.152.
 */
package org.skife.config;

import java.util.Arrays;
import org.skife.config.Coercer;
import org.skife.config.Coercible;

public class CaseInsensitiveEnumCoercible
implements Coercible<Object> {
    @Override
    public Coercer<Object> accept(Class<?> clazz) {
        Enum[] values;
        if (!clazz.isEnum()) {
            return null;
        }
        try {
            values = (Enum[])clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("World seems to be broken, unable to access <EnumType>.values() static method", e);
        }
        return new Coercer<Object>(){

            @Override
            public Object coerce(String value) {
                if (value == null) {
                    return null;
                }
                for (Enum o : values) {
                    if (!value.equalsIgnoreCase(o.toString())) continue;
                    return o;
                }
                throw new IllegalStateException("No enum value of " + Arrays.toString(values) + " matches [" + value + "]");
            }
        };
    }
}

