/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.net.ServerSocket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmbeddedDB {
    protected static final Logger logger = LoggerFactory.getLogger(EmbeddedDB.class);
    protected String databaseName;
    protected String username;
    protected String password;
    protected String jdbcConnectionString;
    protected DataSource dataSource;
    protected List<String> allTables = new LinkedList<String>();
    private static final Pattern WHITESPACE_ONLY = Pattern.compile("^\\s*$");

    protected EmbeddedDB(String databaseName, String username, String password, String jdbcConnectionString) {
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
        this.jdbcConnectionString = jdbcConnectionString;
    }

    public boolean useConnectionPooling() {
        return Boolean.getBoolean("killbill.test.use.connection.pool");
    }

    public abstract DBEngine getDBEngine();

    public abstract void initialize() throws IOException;

    public abstract void start() throws IOException;

    public abstract void refreshTableNames() throws IOException;

    public DataSource getDataSource() throws IOException {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void stop() throws IOException {
        DataSource dataSource = this.getDataSource();
        if (dataSource instanceof HikariDataSource) {
            ((HikariDataSource)dataSource).shutdown();
        }
    }

    public String getCmdLineConnectionString() {
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getJdbcConnectionString() {
        return this.jdbcConnectionString;
    }

    public List<String> getAllTables() {
        return this.allTables;
    }

    protected DataSource createHikariDataSource() throws IOException {
        String dataSourceClassName;
        switch (this.getDBEngine()) {
            case MYSQL: {
                dataSourceClassName = "org.mariadb.jdbc.MySQLDataSource";
                break;
            }
            case POSTGRESQL: {
                dataSourceClassName = "org.postgresql.ds.PGSimpleDataSource";
                break;
            }
            case H2: {
                dataSourceClassName = "org.h2.jdbcx.JdbcDataSource";
                break;
            }
            default: {
                dataSourceClassName = null;
            }
        }
        HikariConfig hikariConfig = new HikariConfig();
        if (this.username != null) {
            hikariConfig.setUsername(this.username);
            hikariConfig.addDataSourceProperty("user", (Object)this.username);
        }
        if (this.password != null) {
            hikariConfig.setPassword(this.password);
            hikariConfig.addDataSourceProperty("password", (Object)this.password);
        }
        if (this.jdbcConnectionString != null) {
            hikariConfig.addDataSourceProperty("url", (Object)this.jdbcConnectionString);
        }
        hikariConfig.setMaximumPoolSize(100);
        hikariConfig.setMinimumIdle(1);
        hikariConfig.setConnectionTimeout(0L);
        hikariConfig.setIdleTimeout(60000000L);
        hikariConfig.setMaxLifetime(0L);
        hikariConfig.setDataSourceClassName(dataSourceClassName);
        return new HikariDataSource(hikariConfig);
    }

    public void executeScript(String script) throws IOException {
        try {
            this.execute(script);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void cleanupAllTables() throws IOException {
        for (String tableName : this.allTables) {
            this.cleanupTable(tableName);
        }
    }

    public void cleanupTable(String table) throws IOException {
        logger.debug("Deleting table: " + table);
        try {
            this.executeUpdate("truncate table " + table);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected void execute(String query) throws SQLException, IOException {
        this.execute(query, new ResultSetJob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String query, ResultSetJob job) throws SQLException, IOException {
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            if (statement.execute(query)) {
                job.work(statement.getResultSet());
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdate(String query) throws SQLException, IOException {
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            int n = statement.executeUpdate(query);
            return n;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuery(String query, ResultSetJob job) throws SQLException, IOException {
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(query);
            job.work(rs);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }

    protected Connection getConnection() throws SQLException, IOException {
        return this.getDataSource().getConnection();
    }

    protected int getPort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static class ResultSetJob {
        protected ResultSetJob() {
        }

        public void work(ResultSet resultSet) throws SQLException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBEngine {
        GENERIC,
        MYSQL,
        H2,
        POSTGRESQL;

    }
}

