/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.mysql;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.io.IOException;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.embeddeddb.GenericStandaloneDB;
import org.mariadb.jdbc.MariaDbDataSource;

public class MySQLStandaloneDB
extends GenericStandaloneDB {
    private final int port;
    private final boolean useMariaDB;

    public MySQLStandaloneDB(String databaseName) {
        this(databaseName, "root", null);
    }

    public MySQLStandaloneDB(String databaseName, String username, String password) {
        this(databaseName, username, password, "jdbc:mysql://localhost:3306/" + databaseName + "?createDatabaseIfNotExist=true&allowMultiQueries=true");
    }

    public MySQLStandaloneDB(String databaseName, String username, String password, String jdbcConnectionString) {
        this(databaseName, username, password, jdbcConnectionString, true);
    }

    public MySQLStandaloneDB(String databaseName, String username, String password, String jdbcConnectionString, boolean useMariaDB) {
        super(databaseName, username, password, jdbcConnectionString);
        this.port = URI.create(jdbcConnectionString.substring(5)).getPort();
        this.useMariaDB = useMariaDB;
    }

    public EmbeddedDB.DBEngine getDBEngine() {
        return EmbeddedDB.DBEngine.MYSQL;
    }

    public void initialize() throws IOException, SQLException {
        super.initialize();
        if (this.useMariaDB) {
            MariaDbDataSource mariaDBDataSource = new MariaDbDataSource();
            try {
                mariaDBDataSource.setUrl(this.jdbcConnectionString);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            mariaDBDataSource.setDatabaseName(this.databaseName);
            mariaDBDataSource.setUser(this.username);
            mariaDBDataSource.setPassword(this.password);
            mariaDBDataSource.setPort(this.port);
            this.dataSource = mariaDBDataSource;
        } else {
            MysqlDataSource mysqlDataSource = new MysqlDataSource();
            mysqlDataSource.setDatabaseName(this.databaseName);
            mysqlDataSource.setUser(this.username);
            mysqlDataSource.setPassword(this.password);
            mysqlDataSource.setPort(this.port);
            mysqlDataSource.setURL(this.jdbcConnectionString);
            this.dataSource = mysqlDataSource;
        }
    }

    public void refreshTableNames() throws IOException {
        String query = String.format("select table_name from information_schema.tables where table_schema = '%s' and table_type = 'BASE TABLE';", this.databaseName);
        try {
            this.executeQuery(query, new EmbeddedDB.ResultSetJob(){

                public void work(ResultSet resultSet) throws SQLException {
                    MySQLStandaloneDB.this.allTables.clear();
                    while (resultSet.next()) {
                        MySQLStandaloneDB.this.allTables.add(resultSet.getString(1));
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public String getCmdLineConnectionString() {
        return String.format("mysql -u%s -p%s -P%s %s", this.username, this.password, this.port, this.databaseName);
    }
}

