/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing.mysql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.mysql.HackedEmbeddedMySql;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HackedTestingMySqlServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(HackedTestingMySqlServer.class);
    private final String user;
    private final String password;
    private final Set<String> databases;
    private final int port;
    private String version;
    private HackedEmbeddedMySql server;

    public HackedTestingMySqlServer(String user, String password, int port, String ... databases) {
        this(user, password, port, (Iterable<String>)ImmutableList.copyOf((Object[])databases));
    }

    public HackedTestingMySqlServer(String user, String password, int port, Iterable<String> databases) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.password = Objects.requireNonNull(password, "password is null");
        this.databases = ImmutableSet.copyOf(Objects.requireNonNull(databases, "databases is null"));
        this.port = port;
    }

    public void start() throws Exception {
        this.server = new HackedEmbeddedMySql(this.port);
        try (Connection connection = this.server.getMySqlDatabase();){
            this.version = connection.getMetaData().getDatabaseProductVersion();
            try (Statement statement = connection.createStatement();){
                HackedTestingMySqlServer.execute(statement, String.format("CREATE USER '%s'@'%%' IDENTIFIED WITH mysql_native_password BY '%s'", this.user, this.password));
                HackedTestingMySqlServer.execute(statement, String.format("GRANT ALL ON *.* to '%s'@'%%' WITH GRANT OPTION", this.user));
                for (String database : this.databases) {
                    HackedTestingMySqlServer.execute(statement, String.format("CREATE DATABASE %s", database));
                }
            }
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
        log.info("MySQL server ready: {}", (Object)this.getJdbcUrl());
    }

    private static void execute(Statement statement, String sql) throws SQLException {
        log.debug("Executing: {}", (Object)sql);
        statement.execute(sql);
    }

    @Override
    public void close() {
        this.server.close();
    }

    public HackedEmbeddedMySql getServer() {
        return this.server;
    }

    public String getMySqlVersion() {
        return this.version;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<String> getDatabases() {
        return this.databases;
    }

    public int getPort() {
        return this.port;
    }

    public String getJdbcUrl() {
        return this.getJdbcUrl("");
    }

    public String getJdbcUrl(String database) {
        return String.format("jdbc:mysql://localhost:%s/%s?user=%s&password=%s&useSSL=false&allowPublicKeyRetrieval=true&createDatabaseIfNotExist=true&allowMultiQueries=true", this.port, database, this.user, this.password);
    }
}

