/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.mysql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.mariadb.jdbc.MariaDbDataSource;
import org.mariadb.jdbc.UrlParser;

public class KillBillMariaDbDataSource
extends MariaDbDataSource {
    private static final Joiner.MapJoiner mapJoiner = Joiner.on((char)'&').withKeyValueSeparator("=");
    private String url;
    private Boolean cachePrepStmts;
    private Integer prepStmtCacheSize;
    private Integer prepStmtCacheSqlLimit;
    private Boolean useServerPrepStmts;

    public void setUrl(String url) throws SQLException {
        this.url = url;
        super.setUrl(url);
        this.updateUrlIfNeeded();
    }

    public void setCachePrepStmts(boolean cachePrepStmts) throws SQLException {
        this.cachePrepStmts = cachePrepStmts;
        this.updateUrlIfNeeded();
    }

    public void setPrepStmtCacheSize(int prepStmtCacheSize) throws SQLException {
        this.prepStmtCacheSize = prepStmtCacheSize;
        this.updateUrlIfNeeded();
    }

    public void setPrepStmtCacheSqlLimit(int prepStmtCacheSqlLimit) throws SQLException {
        this.prepStmtCacheSqlLimit = prepStmtCacheSqlLimit;
        this.updateUrlIfNeeded();
    }

    public void setUseServerPrepStmts(boolean useServerPrepStmts) throws SQLException {
        this.useServerPrepStmts = useServerPrepStmts;
        this.updateUrlIfNeeded();
    }

    private void updateUrlIfNeeded() throws SQLException {
        UrlParser urlParser;
        if (this.url == null && (urlParser = this.initializeAndGetUrlParser()) != null) {
            this.url = urlParser.getInitialUrl();
        }
        if (this.url != null) {
            this.url = this.buildUpdatedUrl(this.url);
            super.setUrl(this.url);
        }
    }

    @VisibleForTesting
    String buildUpdatedUrl(String url) throws SQLException {
        int separator;
        String urlSecondPart;
        int paramIndex;
        Properties props = new Properties();
        UrlParser.parse((String)url, (Properties)props);
        if (this.cachePrepStmts != null && !props.containsKey("cachePrepStmts")) {
            props.put("cachePrepStmts", this.cachePrepStmts);
        }
        if (this.prepStmtCacheSize != null && !props.containsKey("prepStmtCacheSize")) {
            props.put("prepStmtCacheSize", this.prepStmtCacheSize);
        }
        if (this.prepStmtCacheSqlLimit != null && !props.containsKey("prepStmtCacheSqlLimit")) {
            props.put("prepStmtCacheSqlLimit", this.prepStmtCacheSqlLimit);
        }
        if (this.useServerPrepStmts != null && !props.containsKey("useServerPrepStmts")) {
            props.put("useServerPrepStmts", this.useServerPrepStmts);
        }
        String baseUrl = (paramIndex = (urlSecondPart = url.substring((separator = url.indexOf("//")) + 2)).indexOf("?")) > 0 ? url.substring(0, separator + 2 + paramIndex) : url;
        return props.isEmpty() ? baseUrl : baseUrl + "?" + mapJoiner.join((Map)props);
    }

    @VisibleForTesting
    public UrlParser initializeAndGetUrlParser() throws SQLException {
        super.initialize();
        return super.getUrlParser();
    }
}

