/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.postgresql;

import java.io.IOException;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.embeddeddb.GenericStandaloneDB;
import org.postgresql.ds.PGSimpleDataSource;

public class PostgreSQLStandaloneDB
extends GenericStandaloneDB {
    private final int port;

    public PostgreSQLStandaloneDB(String databaseName, String username, String password) {
        this(databaseName, username, password, "jdbc:postgresql://localhost:5432/" + databaseName);
    }

    public PostgreSQLStandaloneDB(String databaseName, String username, String password, String jdbcConnectionString) {
        super(databaseName, username, password, jdbcConnectionString);
        this.port = URI.create(jdbcConnectionString.substring(5)).getPort();
    }

    public EmbeddedDB.DBEngine getDBEngine() {
        return EmbeddedDB.DBEngine.POSTGRESQL;
    }

    public void initialize() throws IOException, SQLException {
        super.initialize();
        this.dataSource = new PGSimpleDataSource();
        ((PGSimpleDataSource)this.dataSource).setDatabaseName(this.databaseName);
        ((PGSimpleDataSource)this.dataSource).setUser(this.username);
        ((PGSimpleDataSource)this.dataSource).setPassword(this.password);
        ((PGSimpleDataSource)this.dataSource).setUrl(this.jdbcConnectionString);
    }

    public void refreshTableNames() throws IOException {
        String query = "select table_name from information_schema.tables where table_schema = current_schema() and table_type = 'BASE TABLE';";
        try {
            this.executeQuery("select table_name from information_schema.tables where table_schema = current_schema() and table_type = 'BASE TABLE';", new EmbeddedDB.ResultSetJob(){

                public void work(ResultSet resultSet) throws SQLException {
                    PostgreSQLStandaloneDB.this.allTables.clear();
                    while (resultSet.next()) {
                        PostgreSQLStandaloneDB.this.allTables.add(resultSet.getString(1));
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public String getCmdLineConnectionString() {
        return String.format("PGPASSWORD=%s psql -U%s -p%s %s", this.password, this.username, this.port, this.databaseName);
    }
}

