/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.embeddeddb.postgresql;

import io.zonky.test.db.postgres.embedded.EmbeddedPostgres;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nullable;
import org.killbill.commons.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KillBillTestingPostgreSqlServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(KillBillTestingPostgreSqlServer.class);
    private final String user;
    private final String database;
    private final int port;
    private final EmbeddedPostgres server;

    public KillBillTestingPostgreSqlServer(String user, String database) throws Exception {
        this(user, null, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KillBillTestingPostgreSqlServer(String user, @Nullable Integer portOrNull, String database) throws Exception {
        Class.forName("org.postgresql.Driver");
        this.user = (String)Preconditions.checkNotNull((Object)user, (Object)"user is null");
        this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"database is null");
        this.server = portOrNull == null ? EmbeddedPostgres.builder().start() : EmbeddedPostgres.builder().setPort(portOrNull.intValue()).start();
        this.port = this.server.getPort();
        Connection connection = null;
        try {
            connection = this.server.getPostgresDatabase().getConnection();
            try (Statement statement = null;){
                statement = connection.createStatement();
                KillBillTestingPostgreSqlServer.execute(statement, String.format("CREATE ROLE %s WITH LOGIN SUPERUSER", user));
                KillBillTestingPostgreSqlServer.execute(statement, String.format("CREATE DATABASE %s OWNER %s ENCODING = 'utf8'", database, user));
            }
        }
        catch (Exception e) {
            if (connection != null) {
                connection.close();
            }
            this.server.close();
            throw e;
        }
        log.info("PostgreSQL server ready: {}", (Object)this.getJdbcUrl());
    }

    private static void execute(Statement statement, String sql) throws SQLException {
        log.debug("Executing: {}", (Object)sql);
        statement.execute(sql);
    }

    @Override
    public void close() throws IOException {
        this.server.close();
    }

    public String getUser() {
        return this.user;
    }

    public String getDatabase() {
        return this.database;
    }

    public int getPort() {
        return this.port;
    }

    public String getJdbcUrl() {
        return this.server.getJdbcUrl(this.user, this.database);
    }
}

