/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.binder;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.killbill.commons.jdbi.binder.SmartBindBean;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;

public class SmartBindBeanFactory
implements BinderFactory {
    private static final Binder<SmartBindBean, Object> SMART_BINDER = new Binder<SmartBindBean, Object>(){

        @Override
        public void bind(SQLStatement q, SmartBindBean bind, Object arg) {
            String prefix = "___jdbi_bare___".equals(bind.value()) ? null : bind.value() + ".";
            try {
                PropertyDescriptor[] props;
                BeanInfo infos = Introspector.getBeanInfo(arg.getClass());
                for (PropertyDescriptor prop : props = infos.getPropertyDescriptors()) {
                    Method readMethod = prop.getReadMethod();
                    if (readMethod == null) continue;
                    String name = prefix == null ? prop.getName() : prefix + prop.getName();
                    q.dynamicBind(readMethod.getReturnType(), name, readMethod.invoke(arg, new Object[0]));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to bind bean properties", e);
            }
        }
    };

    public Binder build(Annotation annotation) {
        return SMART_BINDER;
    }
}

