/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.mapper;

import com.google.common.base.CaseFormat;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowerToCamelBeanMapper<T>
implements ResultSetMapper<T> {
    private final Class<T> type;
    private final Map<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();

    public LowerToCamelBeanMapper(Class<T> type) {
        this.type = type;
        try {
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                this.properties.put(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, descriptor.getName()).toLowerCase(), descriptor);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T map(int row, ResultSet rs, StatementContext ctx) throws SQLException {
        T bean;
        try {
            bean = this.type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("A bean, %s, was mapped which was not instantiable", this.type.getName()), e);
        }
        Class<?> beanClass = bean.getClass();
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String enumString;
            String uuidString;
            String dateTimeZoneString;
            String dateString;
            Timestamp timestamp;
            String name = metadata.getColumnLabel(i).toLowerCase();
            PropertyDescriptor descriptor = this.properties.get(name);
            if (descriptor == null) continue;
            Class<Object> type = descriptor.getPropertyType();
            Object value = type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE) ? Boolean.valueOf(rs.getBoolean(i)) : (type.isAssignableFrom(Byte.class) || type.isAssignableFrom(Byte.TYPE) ? Byte.valueOf(rs.getByte(i)) : (type.isAssignableFrom(Short.class) || type.isAssignableFrom(Short.TYPE) ? Short.valueOf(rs.getShort(i)) : (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE) ? Integer.valueOf(rs.getInt(i)) : (type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE) ? Long.valueOf(rs.getLong(i)) : (type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE) ? Float.valueOf(rs.getFloat(i)) : (type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE) ? Double.valueOf(rs.getDouble(i)) : (type.isAssignableFrom(BigDecimal.class) ? rs.getBigDecimal(i) : (type.isAssignableFrom(DateTime.class) ? ((timestamp = rs.getTimestamp(i)) == null ? null : new DateTime((Object)timestamp).toDateTime(DateTimeZone.UTC)) : (type.isAssignableFrom(Time.class) ? rs.getTime(i) : (type.isAssignableFrom(LocalDate.class) ? ((dateString = rs.getString(i)) == null ? null : new LocalDate((Object)dateString, DateTimeZone.UTC)) : (type.isAssignableFrom(DateTimeZone.class) ? ((dateTimeZoneString = rs.getString(i)) == null ? null : DateTimeZone.forID((String)dateTimeZoneString)) : (type.isAssignableFrom(String.class) ? rs.getString(i) : (type.isAssignableFrom(UUID.class) ? ((uuidString = rs.getString(i)) == null ? null : UUID.fromString(uuidString)) : (type.isEnum() ? ((enumString = rs.getString(i)) == null ? null : Enum.valueOf(type, enumString)) : (type == byte[].class ? (Object)rs.getBytes(i) : rs.getObject(i))))))))))))))));
            if (value instanceof Blob) {
                Blob blob = (Blob)value;
                value = blob.getBytes(0L, (int)blob.length());
            }
            if (rs.wasNull() && !type.isPrimitive()) {
                value = null;
            }
            try {
                Method writeMethod = descriptor.getWriteMethod();
                if (writeMethod != null) {
                    writeMethod.invoke(bean, value);
                    continue;
                }
                String camelCasedName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
                Field field = LowerToCamelBeanMapper.getField(beanClass, camelCasedName);
                field.setAccessible(true);
                field.set(bean, value);
                continue;
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(String.format("Unable to find field for property, %s", name), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Unable to access setter for property, %s", name), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Invocation target exception trying to invoker setter for the %s property", name), e);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException(String.format("No appropriate method to write value %s ", value.toString()), e);
            }
        }
        return bean;
    }

    private static Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return LowerToCamelBeanMapper.getField(superClass, fieldName);
        }
    }
}

