/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.ResultSetException;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMapper
implements ResultSetMapper<Map<String, Object>> {
    @Override
    public Map<String, Object> map(int index, ResultSet r, StatementContext ctx) {
        ResultSetMetaData m;
        DefaultResultMap row = new DefaultResultMap();
        try {
            m = r.getMetaData();
        }
        catch (SQLException e) {
            throw new ResultSetException("Unable to obtain metadata from result set", e, ctx);
        }
        try {
            for (int i = 1; i <= m.getColumnCount(); ++i) {
                String key = m.getColumnName(i);
                String alias = m.getColumnLabel(i);
                Object value = r.getObject(i);
                row.put(alias != null ? alias : key, value);
            }
        }
        catch (SQLException e) {
            throw new ResultSetException("Unable to access specific metadata from result set metadata", e, ctx);
        }
        return row;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultResultMap
    extends HashMap<String, Object> {
        public static final long serialVersionUID = 1L;

        private DefaultResultMap() {
        }

        @Override
        public Object get(Object o) {
            return super.get(((String)o).toLowerCase());
        }

        @Override
        public Object put(String key, Object value) {
            return super.put(key.toLowerCase(), value);
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(((String)key).toLowerCase());
        }
    }
}

