/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.tweak.transactions;

import java.sql.SQLException;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.exceptions.TransactionException;
import org.skife.jdbi.v2.tweak.TransactionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMTTransactionHandler
implements TransactionHandler {
    @Override
    public void begin(Handle handle) {
    }

    @Override
    public void commit(Handle handle) {
    }

    @Override
    public void rollback(Handle handle) {
        throw new TransactionException("Rollback called, this runtime exception thrown to halt the transaction");
    }

    @Override
    public void rollback(Handle handle, String name) {
        throw new UnsupportedOperationException("Checkpoints not implemented");
    }

    @Override
    public boolean isInTransaction(Handle handle) {
        try {
            return !handle.getConnection().getAutoCommit();
        }
        catch (SQLException e) {
            throw new TransactionException("Failed to check status of transaction", e);
        }
    }

    @Override
    public void checkpoint(Handle handle, String name) {
        throw new UnsupportedOperationException("Checkpoints not implemented");
    }

    @Override
    public void release(Handle handle, String checkpointName) {
        throw new TransactionException("Rollback called, this runtime exception thrown to halt the transaction");
    }

    @Override
    public <ReturnType> ReturnType inTransaction(Handle handle, TransactionCallback<ReturnType> callback) {
        try {
            return callback.inTransaction(handle, new ExplodingTransactionStatus(handle));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionException(e);
        }
    }

    @Override
    public <ReturnType> ReturnType inTransaction(Handle handle, TransactionIsolationLevel level, TransactionCallback<ReturnType> callback) {
        return this.inTransaction(handle, callback);
    }

    private class ExplodingTransactionStatus
    implements TransactionStatus {
        private final Handle handle;

        ExplodingTransactionStatus(Handle handle) {
            this.handle = handle;
        }

        public void setRollbackOnly() {
            CMTTransactionHandler.this.rollback(this.handle);
        }
    }
}

