/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypedMapper<T>
implements ResultSetMapper<T> {
    private final ResultSetMapper<T> internal;

    public TypedMapper() {
        this(1);
    }

    public TypedMapper(int index) {
        this.internal = new IndexMapper(index);
    }

    public TypedMapper(String name) {
        this.internal = new StringMapper(name);
    }

    @Override
    public final T map(int index, ResultSet r, StatementContext ctx) throws SQLException {
        return this.internal.map(index, r, ctx);
    }

    protected abstract T extractByName(ResultSet var1, String var2) throws SQLException;

    protected abstract T extractByIndex(ResultSet var1, int var2) throws SQLException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexMapper
    implements ResultSetMapper<T> {
        private final int index;

        IndexMapper(int index) {
            this.index = index;
        }

        @Override
        public T map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return TypedMapper.this.extractByIndex(r, this.index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringMapper
    implements ResultSetMapper<T> {
        private final String name;

        StringMapper(String name) {
            this.name = name;
        }

        @Override
        public T map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return TypedMapper.this.extractByName(r, this.name);
        }
    }
}

