/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi;

import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.regex.Matcher;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.StatementLocator;

public class ReusableStringTemplate3StatementLocator
implements StatementLocator {
    protected final StringTemplateGroup group;
    protected final StringTemplateGroup literals = new StringTemplateGroup("literals", AngleBracketTemplateLexer.class);
    protected final boolean treatLiteralsAsTemplates;
    private static final String sep = "/";

    public ReusableStringTemplate3StatementLocator(Class baseClass) {
        this(ReusableStringTemplate3StatementLocator.mungify(sep + baseClass.getName()) + ".sql.stg", false, false);
    }

    public ReusableStringTemplate3StatementLocator(String templateGroupFilePathOnClasspath) {
        this(templateGroupFilePathOnClasspath, false, false);
    }

    public ReusableStringTemplate3StatementLocator(Class baseClass, boolean allowImplicitTemplateGroup, boolean treatLiteralsAsTemplates) {
        this(ReusableStringTemplate3StatementLocator.mungify(sep + baseClass.getName()) + ".sql.stg", allowImplicitTemplateGroup, treatLiteralsAsTemplates);
    }

    public ReusableStringTemplate3StatementLocator(String templateGroupFilePathOnClasspath, boolean allowImplicitTemplateGroup, boolean treatLiteralsAsTemplates) {
        this.treatLiteralsAsTemplates = treatLiteralsAsTemplates;
        InputStream ins = this.getClass().getResourceAsStream(templateGroupFilePathOnClasspath);
        if (allowImplicitTemplateGroup && ins == null) {
            this.group = new StringTemplateGroup("empty template group", AngleBracketTemplateLexer.class);
        } else {
            if (ins == null) {
                throw new IllegalStateException("unable to find group file " + templateGroupFilePathOnClasspath + " on classpath");
            }
            InputStreamReader reader = new InputStreamReader(ins);
            try {
                this.group = new StringTemplateGroup((Reader)reader, AngleBracketTemplateLexer.class);
                reader.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to load string template group " + templateGroupFilePathOnClasspath, e);
            }
        }
    }

    public synchronized String locate(String name, StatementContext ctx) throws Exception {
        if (this.group.isDefined(name)) {
            StringTemplate t = this.group.lookupTemplate(name);
            for (Map.Entry entry : ctx.getAttributes().entrySet()) {
                t.setAttribute((String)entry.getKey(), entry.getValue());
            }
            String sql = t.toString();
            t.setAttributes(null);
            return sql;
        }
        if (this.treatLiteralsAsTemplates) {
            String key = BaseEncoding.base64().encode(name.getBytes(Charsets.US_ASCII));
            if (!this.literals.isDefined(key)) {
                this.literals.defineTemplate(key, name);
            }
            StringTemplate t = this.literals.lookupTemplate(key);
            for (Map.Entry entry : ctx.getAttributes().entrySet()) {
                t.setAttribute((String)entry.getKey(), entry.getValue());
            }
            String sql = t.toString();
            t.setAttributes(null);
            return sql;
        }
        return name;
    }

    private static String mungify(String path) {
        return path.replaceAll("\\.", Matcher.quoteReplacement(sep));
    }
}

