/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.argument;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeArgumentFactory
implements ArgumentFactory<DateTime> {
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof DateTime;
    }

    public Argument build(Class<?> expectedType, DateTime value, StatementContext ctx) {
        return new DateTimeArgument(value);
    }

    public static class DateTimeArgument
    implements Argument {
        private final DateTime value;

        public DateTimeArgument(DateTime value) {
            this.value = value;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.value != null) {
                statement.setTimestamp(position, new Timestamp(this.value.toDate().getTime()));
            } else {
                statement.setNull(position, 93);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DateTimeArgument");
            sb.append("{value=").append(this.value);
            sb.append('}');
            return sb.toString();
        }
    }
}

