/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.argument;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeZoneArgumentFactory
implements ArgumentFactory<DateTimeZone> {
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof DateTimeZone;
    }

    public Argument build(Class<?> expectedType, DateTimeZone value, StatementContext ctx) {
        return new DateTimeZoneArgument(value);
    }

    public class DateTimeZoneArgument
    implements Argument {
        private final DateTimeZone value;

        public DateTimeZoneArgument(DateTimeZone value) {
            this.value = value;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.value != null) {
                statement.setString(position, this.value.toString());
            } else {
                statement.setNull(position, 12);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DateTimeZoneArgument");
            sb.append("{value=").append(this.value);
            sb.append('}');
            return sb.toString();
        }
    }
}

