/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.argument;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.joda.time.LocalDate;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDateArgumentFactory
implements ArgumentFactory<LocalDate> {
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof LocalDate;
    }

    public Argument build(Class<?> expectedType, LocalDate value, StatementContext ctx) {
        return new LocalDateArgument(value);
    }

    public static class LocalDateArgument
    implements Argument {
        private static final String POSTGRESQL = "PostgreSQL";
        private final LocalDate value;

        public LocalDateArgument(LocalDate value) {
            this.value = value;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.value != null && ctx != null && ctx.getConnection() != null && ctx.getConnection().getMetaData() != null && POSTGRESQL.equalsIgnoreCase(ctx.getConnection().getMetaData().getDatabaseProductName())) {
                statement.setDate(position, new Date(this.value.toDate().getTime()));
            } else if (this.value != null) {
                statement.setString(position, this.value.toString());
            } else {
                statement.setNull(position, 12);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("LocalDateArgument");
            sb.append("{value=").append(this.value);
            sb.append('}');
            return sb.toString();
        }
    }
}

