/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.binder;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.commons.jdbi.binder.BinderBase;
import org.killbill.commons.jdbi.binder.SmartBindBean;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;

public class SmartBindBeanFactory
extends BinderBase
implements BinderFactory {
    public Binder build(Annotation annotation) {
        return new Binder<SmartBindBean, Object>(){

            public void bind(SQLStatement q, SmartBindBean bind, Object arg) {
                String prefix = "___jdbi_bare___".equals(bind.value()) ? "" : bind.value() + ".";
                try {
                    PropertyDescriptor[] props;
                    BeanInfo infos = Introspector.getBeanInfo(arg.getClass());
                    for (PropertyDescriptor prop : props = infos.getPropertyDescriptors()) {
                        Method readMethod = prop.getReadMethod();
                        if (readMethod == null) continue;
                        String bindingName = prefix + prop.getName();
                        Object value = readMethod.invoke(arg, new Object[0]);
                        if (value == null) {
                            q.bind(bindingName, null);
                            continue;
                        }
                        if (value instanceof DateTime) {
                            q.bind(bindingName, SmartBindBeanFactory.this.getDate((DateTime)value));
                            continue;
                        }
                        if (value instanceof DateTimeZone) {
                            q.bind(bindingName, value.toString());
                            continue;
                        }
                        if (value instanceof Enum || value.getClass().isEnum()) {
                            q.bind(bindingName, value.toString());
                            continue;
                        }
                        if (value instanceof LocalDate) {
                            q.bind(bindingName, value.toString());
                            continue;
                        }
                        if (value instanceof UUID) {
                            q.bind(bindingName, SmartBindBeanFactory.this.getUUIDString((UUID)value));
                            continue;
                        }
                        q.bind(bindingName, value);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("unable to bind bean properties", e);
                }
            }
        };
    }
}

