/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.log;

import org.killbill.commons.jdbi.log.LogLevel;
import org.skife.jdbi.v2.logging.FormattedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLogging
extends FormattedLog {
    private final Logger logger;
    private final LogLevel logLevel;

    public Slf4jLogging() {
        this(LoggerFactory.getLogger(Slf4jLogging.class));
    }

    public Slf4jLogging(Logger logger) {
        this(logger, LogLevel.DEBUG);
    }

    public Slf4jLogging(Logger logger, LogLevel logLevel) {
        this.logger = logger;
        this.logLevel = logLevel;
    }

    protected boolean isEnabled() {
        if (this.logLevel == LogLevel.DEBUG) {
            return this.logger.isDebugEnabled();
        }
        if (this.logLevel == LogLevel.TRACE) {
            return this.logger.isTraceEnabled();
        }
        if (this.logLevel == LogLevel.INFO) {
            return this.logger.isInfoEnabled();
        }
        if (this.logLevel == LogLevel.WARN) {
            return this.logger.isWarnEnabled();
        }
        if (this.logLevel == LogLevel.ERROR) {
            return this.logger.isErrorEnabled();
        }
        return false;
    }

    protected void log(String msg) {
        if (this.logLevel.equals((Object)LogLevel.DEBUG)) {
            this.logger.debug(msg);
        } else if (this.logLevel.equals((Object)LogLevel.TRACE)) {
            this.logger.trace(msg);
        } else if (this.logLevel.equals((Object)LogLevel.INFO)) {
            this.logger.info(msg);
        } else if (this.logLevel.equals((Object)LogLevel.WARN)) {
            this.logger.warn(msg);
        } else if (this.logLevel.equals((Object)LogLevel.ERROR)) {
            this.logger.error(msg);
        }
    }
}

