/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMapper<T>
implements ResultSetMapper<T> {
    private final Class<T> type;
    private final Map<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();

    public BeanMapper(Class<T> type) {
        this.type = type;
        try {
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                this.properties.put(descriptor.getName().toLowerCase(), descriptor);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T map(int row, ResultSet rs, StatementContext ctx) throws SQLException {
        T bean;
        try {
            bean = this.type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("A bean, %s, was mapped which was not instantiable", this.type.getName()), e);
        }
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String str;
            String name = metadata.getColumnLabel(i).toLowerCase();
            PropertyDescriptor descriptor = this.properties.get(name);
            if (descriptor == null) continue;
            Class<Object> type = descriptor.getPropertyType();
            Object value = type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE) ? Boolean.valueOf(rs.getBoolean(i)) : (type.isAssignableFrom(Byte.class) || type.isAssignableFrom(Byte.TYPE) ? Byte.valueOf(rs.getByte(i)) : (type.isAssignableFrom(Short.class) || type.isAssignableFrom(Short.TYPE) ? Short.valueOf(rs.getShort(i)) : (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE) ? Integer.valueOf(rs.getInt(i)) : (type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE) ? Long.valueOf(rs.getLong(i)) : (type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE) ? Float.valueOf(rs.getFloat(i)) : (type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE) ? Double.valueOf(rs.getDouble(i)) : (type.isAssignableFrom(BigDecimal.class) ? rs.getBigDecimal(i) : (type.isAssignableFrom(Timestamp.class) ? rs.getTimestamp(i) : (type.isAssignableFrom(Time.class) ? rs.getTime(i) : (type.isAssignableFrom(Date.class) ? rs.getDate(i) : (type.isAssignableFrom(String.class) ? rs.getString(i) : (type.isEnum() ? ((str = rs.getString(i)) != null ? Enum.valueOf(type, str) : null) : rs.getObject(i)))))))))))));
            if (rs.wasNull() && !type.isPrimitive()) {
                value = null;
            }
            try {
                descriptor.getWriteMethod().invoke(bean, value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Unable to access setter for property, %s", name), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Invocation target exception trying to invoker setter for the %s property", name), e);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException(String.format("No appropriate method to write property %s", name), e);
            }
        }
        return bean;
    }
}

