/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.exceptions;

import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.DBIException;

public abstract class StatementException
extends DBIException {
    private final StatementContext statementContext;

    public StatementException(String string, Throwable throwable, StatementContext ctx) {
        super(string, throwable);
        this.statementContext = ctx;
    }

    public StatementException(Throwable cause, StatementContext ctx) {
        super(cause);
        this.statementContext = ctx;
    }

    public StatementException(String message, StatementContext ctx) {
        super(message);
        this.statementContext = ctx;
    }

    public StatementException(String string, Throwable throwable) {
        super(string, throwable);
        this.statementContext = null;
    }

    public StatementException(Throwable cause) {
        super(cause);
        this.statementContext = null;
    }

    public StatementException(String message) {
        super(message);
        this.statementContext = null;
    }

    public StatementContext getStatementContext() {
        return this.statementContext;
    }

    public String getMessage() {
        String base = super.getMessage();
        StatementContext ctx = this.getStatementContext();
        if (ctx == null) {
            return base;
        }
        return String.format("%s [statement:\"%s\", located:\"%s\", rewritten:\"%s\", arguments:%s]", base, ctx.getRawSql(), ctx.getLocatedSql(), ctx.getRewrittenSql(), ctx.getBinding());
    }
}

