/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import com.fasterxml.classmate.members.ResolvedMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.sqlobject.BinderFactory;
import org.skife.jdbi.v2.sqlobject.Bindifier;
import org.skife.jdbi.v2.sqlobject.BindingAnnotation;
import org.skife.jdbi.v2.sqlobject.Handler;
import org.skife.jdbi.v2.sqlobject.PositionalBinder;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CustomizingStatementHandler
implements Handler {
    private final List<Bindifier> binders = new ArrayList<Bindifier>();
    private final List<FactoryAnnotationPair> typeBasedCustomizerFactories = new ArrayList<FactoryAnnotationPair>();
    private final List<FactoryAnnotationPair> methodBasedCustomizerFactories = new ArrayList<FactoryAnnotationPair>();
    private final List<FactoryAnnotationIndexTriple> paramBasedCustomizerFactories = new ArrayList<FactoryAnnotationIndexTriple>();
    private final Class<?> sqlObjectType;
    private final Method method;

    CustomizingStatementHandler(Class<?> sqlObjectType, ResolvedMethod method) {
        Annotation[] method_annotations;
        this.sqlObjectType = sqlObjectType;
        this.method = (Method)method.getRawMember();
        for (Annotation annotation : sqlObjectType.getAnnotations()) {
            SqlStatementCustomizerFactory f;
            if (!annotation.annotationType().isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
            SqlStatementCustomizingAnnotation a = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
            try {
                f = a.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create sql statement customizer factory", e);
            }
            this.typeBasedCustomizerFactories.add(new FactoryAnnotationPair(f, annotation));
        }
        for (Annotation method_annotation : method_annotations = ((Method)method.getRawMember()).getAnnotations()) {
            SqlStatementCustomizerFactory f;
            Class<? extends Annotation> m_anno_class = method_annotation.annotationType();
            if (!m_anno_class.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
            SqlStatementCustomizingAnnotation scf = m_anno_class.getAnnotation(SqlStatementCustomizingAnnotation.class);
            try {
                f = scf.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to instantiate statement customizer factory", e);
            }
            this.methodBasedCustomizerFactories.add(new FactoryAnnotationPair(f, method_annotation));
        }
        Annotation[][] param_annotations = ((Method)method.getRawMember()).getParameterAnnotations();
        for (int param_idx = 0; param_idx < param_annotations.length; ++param_idx) {
            boolean thereBindingAnnotation = false;
            for (Annotation annotation : param_annotations[param_idx]) {
                SqlStatementCustomizerFactory f;
                Class<? extends Annotation> anno_class = annotation.annotationType();
                if (anno_class.isAnnotationPresent(BindingAnnotation.class)) {
                    BindingAnnotation ba = annotation.annotationType().getAnnotation(BindingAnnotation.class);
                    try {
                        BinderFactory fact = ba.value().newInstance();
                        this.binders.add(new Bindifier(annotation, param_idx, fact.build(annotation)));
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("unable to instantiate cusotmizer", e);
                    }
                    thereBindingAnnotation = true;
                }
                if (!anno_class.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)) continue;
                SqlStatementCustomizingAnnotation sca = annotation.annotationType().getAnnotation(SqlStatementCustomizingAnnotation.class);
                try {
                    f = sca.value().newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("unable to instantiate sql statement customizer factory", e);
                }
                this.paramBasedCustomizerFactories.add(new FactoryAnnotationIndexTriple(f, annotation, param_idx));
                thereBindingAnnotation = true;
            }
            if (thereBindingAnnotation) continue;
            this.binders.add(new Bindifier(null, param_idx, new PositionalBinder(param_idx)));
        }
    }

    protected final void populateSqlObjectData(ConcreteStatementContext q) {
        q.setSqlObjectMethod(this.method);
        q.setSqlObjectType(this.sqlObjectType);
    }

    protected void applyBinders(SQLStatement<?> q, Object[] args) {
        for (Bindifier binder : this.binders) {
            binder.bind(q, args);
        }
    }

    protected void applyCustomizers(SQLStatement<?> q, Object[] args) {
        for (FactoryAnnotationPair pair : this.typeBasedCustomizerFactories) {
            try {
                pair.factory.createForType(pair.annotation, this.sqlObjectType).apply(q);
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException("unable to apply customizer", e, q.getContext());
            }
        }
        for (FactoryAnnotationPair pair : this.methodBasedCustomizerFactories) {
            try {
                pair.factory.createForMethod(pair.annotation, this.sqlObjectType, this.method).apply(q);
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException("unable to apply customizer", e, q.getContext());
            }
        }
        if (args != null) {
            for (FactoryAnnotationIndexTriple triple : this.paramBasedCustomizerFactories) {
                try {
                    triple.factory.createForParameter(triple.annotation, this.sqlObjectType, this.method, args[triple.index]).apply(q);
                }
                catch (SQLException e) {
                    throw new UnableToCreateStatementException("unable to apply customizer", e, q.getContext());
                }
            }
        }
    }

    private static class FactoryAnnotationIndexTriple {
        private final SqlStatementCustomizerFactory factory;
        private final Annotation annotation;
        private final int index;

        FactoryAnnotationIndexTriple(SqlStatementCustomizerFactory factory, Annotation annotation, int index) {
            this.factory = factory;
            this.annotation = annotation;
            this.index = index;
        }
    }

    private static class FactoryAnnotationPair {
        private final SqlStatementCustomizerFactory factory;
        private final Annotation annotation;

        FactoryAnnotationPair(SqlStatementCustomizerFactory factory, Annotation annotation) {
            this.factory = factory;
            this.annotation = annotation;
        }
    }
}

