/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.Call;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.ContainerFactoryRegistry;
import org.skife.jdbi.v2.DefaultMapper;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.MappingRegistry;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.Script;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.UnableToCloseResourceException;
import org.skife.jdbi.v2.exceptions.UnableToManipulateTransactionIsolationLevelException;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ContainerFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementBuilder;
import org.skife.jdbi.v2.tweak.StatementCustomizer;
import org.skife.jdbi.v2.tweak.StatementLocator;
import org.skife.jdbi.v2.tweak.StatementRewriter;
import org.skife.jdbi.v2.tweak.TransactionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicHandle
implements Handle {
    private static final DefaultMapper DEFAULT_MAPPER = new DefaultMapper();
    private StatementRewriter statementRewriter;
    private StatementLocator statementLocator;
    private SQLLog log;
    private TimingCollector timingCollector;
    private StatementBuilder statementBuilder;
    private boolean closed = false;
    private final Map<String, Object> globalStatementAttributes;
    private final MappingRegistry mappingRegistry;
    private final ContainerFactoryRegistry containerFactoryRegistry;
    private final Foreman foreman;
    private final TransactionHandler transactions;
    private final Connection connection;

    BasicHandle(TransactionHandler transactions, StatementLocator statementLocator, StatementBuilder preparedStatementCache, StatementRewriter statementRewriter, Connection connection, Map<String, Object> globalStatementAttributes, SQLLog log, TimingCollector timingCollector, MappingRegistry mappingRegistry, Foreman foreman, ContainerFactoryRegistry containerFactoryRegistry) {
        this.statementBuilder = preparedStatementCache;
        this.statementRewriter = statementRewriter;
        this.transactions = transactions;
        this.connection = connection;
        this.statementLocator = statementLocator;
        this.log = log;
        this.timingCollector = timingCollector;
        this.mappingRegistry = mappingRegistry;
        this.foreman = foreman;
        this.globalStatementAttributes = new HashMap<String, Object>();
        this.globalStatementAttributes.putAll(globalStatementAttributes);
        this.containerFactoryRegistry = containerFactoryRegistry.createChild();
    }

    @Override
    public Query<Map<String, Object>> createQuery(String sql) {
        return new Query<Map<String, Object>>(new Binding(), DEFAULT_MAPPER, this.statementLocator, this.statementRewriter, this, this.statementBuilder, sql, new ConcreteStatementContext(this.globalStatementAttributes), this.log, this.timingCollector, Collections.<StatementCustomizer>emptyList(), this.mappingRegistry.createChild(), this.foreman.createChild(), this.containerFactoryRegistry.createChild());
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.statementBuilder.close(this.getConnection());
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new UnableToCloseResourceException("Unable to close Connection", e);
            }
            finally {
                this.log.logReleaseHandle(this);
                this.closed = true;
            }
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public void define(String key, Object value) {
        this.globalStatementAttributes.put(key, value);
    }

    @Override
    public Handle begin() {
        this.transactions.begin(this);
        this.log.logBeginTransaction(this);
        return this;
    }

    @Override
    public Handle commit() {
        long start = System.nanoTime();
        this.transactions.commit(this);
        this.log.logCommitTransaction((System.nanoTime() - start) / 1000000L, this);
        return this;
    }

    @Override
    public Handle rollback() {
        long start = System.nanoTime();
        this.transactions.rollback(this);
        this.log.logRollbackTransaction((System.nanoTime() - start) / 1000000L, this);
        return this;
    }

    @Override
    public Handle checkpoint(String name) {
        this.transactions.checkpoint(this, name);
        this.log.logCheckpointTransaction(this, name);
        return this;
    }

    @Override
    public Handle release(String checkpointName) {
        this.transactions.release(this, checkpointName);
        this.log.logReleaseCheckpointTransaction(this, checkpointName);
        return this;
    }

    @Override
    public void setStatementBuilder(StatementBuilder builder) {
        this.statementBuilder = builder;
    }

    @Override
    public void setSQLLog(SQLLog log) {
        this.log = log;
    }

    @Override
    public void setTimingCollector(TimingCollector timingCollector) {
        this.timingCollector = timingCollector == null ? TimingCollector.NOP_TIMING_COLLECTOR : timingCollector;
    }

    @Override
    public Handle rollback(String checkpointName) {
        long start = System.nanoTime();
        this.transactions.rollback(this, checkpointName);
        this.log.logRollbackToCheckpoint((System.nanoTime() - start) / 1000000L, this, checkpointName);
        return this;
    }

    @Override
    public boolean isInTransaction() {
        return this.transactions.isInTransaction(this);
    }

    @Override
    public Update createStatement(String sql) {
        return new Update(this, this.statementLocator, this.statementRewriter, this.statementBuilder, sql, new ConcreteStatementContext(this.globalStatementAttributes), this.log, this.timingCollector, this.foreman, this.containerFactoryRegistry);
    }

    @Override
    public Call createCall(String sql) {
        return new Call(this, this.statementLocator, this.statementRewriter, this.statementBuilder, sql, new ConcreteStatementContext(this.globalStatementAttributes), this.log, this.timingCollector, Collections.<StatementCustomizer>emptyList(), this.foreman, this.containerFactoryRegistry);
    }

    @Override
    public int insert(String sql, Object ... args) {
        return this.update(sql, args);
    }

    @Override
    public int update(String sql, Object ... args) {
        Update stmt = this.createStatement(sql);
        int position = 0;
        for (Object arg : args) {
            stmt.bind(position++, arg);
        }
        return stmt.execute();
    }

    @Override
    public PreparedBatch prepareBatch(String sql) {
        return new PreparedBatch(this.statementLocator, this.statementRewriter, this, this.statementBuilder, sql, new ConcreteStatementContext(this.globalStatementAttributes), this.log, this.timingCollector, Collections.<StatementCustomizer>emptyList(), this.foreman, this.containerFactoryRegistry);
    }

    @Override
    public Batch createBatch() {
        return new Batch(this.statementRewriter, this.connection, this.globalStatementAttributes, this.log, this.timingCollector, this.foreman.createChild());
    }

    @Override
    public <ReturnType> ReturnType inTransaction(TransactionCallback<ReturnType> callback) {
        return this.transactions.inTransaction(this, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnType> ReturnType inTransaction(TransactionIsolationLevel level, TransactionCallback<ReturnType> callback) {
        TransactionIsolationLevel initial = this.getTransactionIsolationLevel();
        boolean failed = true;
        try {
            this.setTransactionIsolation(level);
            ReturnType result = this.transactions.inTransaction(this, level, callback);
            failed = false;
            ReturnType ReturnType = result;
            return ReturnType;
        }
        finally {
            block7: {
                try {
                    this.setTransactionIsolation(initial);
                }
                catch (RuntimeException e) {
                    if (failed) break block7;
                    throw e;
                }
            }
        }
    }

    @Override
    public List<Map<String, Object>> select(String sql, Object ... args) {
        Query<Map<String, Object>> query = this.createQuery(sql);
        int position = 0;
        for (Object arg : args) {
            query.bind(position++, arg);
        }
        return query.list();
    }

    @Override
    public void setStatementLocator(StatementLocator locator) {
        this.statementLocator = locator;
    }

    @Override
    public void setStatementRewriter(StatementRewriter rewriter) {
        this.statementRewriter = rewriter;
    }

    @Override
    public Script createScript(String name) {
        return new Script(this, this.statementLocator, name, this.globalStatementAttributes);
    }

    @Override
    public void execute(String sql, Object ... args) {
        this.update(sql, args);
    }

    @Override
    public void registerMapper(ResultSetMapper mapper) {
        throw new UnsupportedOperationException("[OPTIMIZATION] Registering a custom ResultSetMapper on a Handle is disabled");
    }

    @Override
    public void registerMapper(ResultSetMapperFactory factory) {
        throw new UnsupportedOperationException("[OPTIMIZATION] Registering a custom ResultSetMapperFactory on a Handle is disabled");
    }

    @Override
    public <SqlObjectType> SqlObjectType attach(Class<SqlObjectType> sqlObjectType) {
        return SqlObjectBuilder.attach(this, sqlObjectType);
    }

    @Override
    public void setTransactionIsolation(TransactionIsolationLevel level) {
        this.setTransactionIsolation(level.intValue());
    }

    @Override
    public void setTransactionIsolation(int level) {
        try {
            if (this.connection.getTransactionIsolation() == level) {
                return;
            }
            this.connection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException(level, e);
        }
    }

    @Override
    public TransactionIsolationLevel getTransactionIsolationLevel() {
        try {
            return TransactionIsolationLevel.valueOf(this.connection.getTransactionIsolation());
        }
        catch (SQLException e) {
            throw new UnableToManipulateTransactionIsolationLevelException("unable to access current setting", e);
        }
    }

    @Override
    public void registerArgumentFactory(ArgumentFactory argumentFactory) {
        throw new UnsupportedOperationException("[OPTIMIZATION] Registering a custom ArgumentFactory on a Handle is disabled");
    }

    @Override
    public void registerContainerFactory(ContainerFactory<?> factory) {
        this.containerFactoryRegistry.register(factory);
    }
}

