/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.skife.jdbi.v2.Cleanables;
import org.skife.jdbi.v2.ContainerFactoryRegistry;
import org.skife.jdbi.v2.Folder2;
import org.skife.jdbi.v2.ResultBearing;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.ResultSetResultIterator;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.ResultSetException;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedKeys<Type>
implements ResultBearing<Type> {
    private final ResultSetMapper<Type> mapper;
    private final SQLStatement<?> jdbiStatement;
    private final Statement stmt;
    private final ResultSet results;
    private final StatementContext context;
    private final ContainerFactoryRegistry containerFactoryRegistry;

    GeneratedKeys(ResultSetMapper<Type> mapper, SQLStatement<?> jdbiStatement, Statement stmt, StatementContext context, ContainerFactoryRegistry containerFactoryRegistry) throws SQLException {
        this.mapper = mapper;
        this.jdbiStatement = jdbiStatement;
        this.stmt = stmt;
        this.results = stmt.getGeneratedKeys();
        this.context = context;
        this.containerFactoryRegistry = containerFactoryRegistry.createChild();
        this.jdbiStatement.addCleanable(Cleanables.forResultSet(this.results));
    }

    @Override
    public Type first() {
        try {
            if (this.results != null && this.results.next()) {
                Type Type2 = this.mapper.map(0, this.results, this.context);
                return Type2;
            }
            Type Type3 = null;
            return Type3;
        }
        catch (SQLException e) {
            throw new ResultSetException("Exception thrown while attempting to traverse the result set", e, this.context);
        }
        finally {
            this.jdbiStatement.cleanup();
        }
    }

    @Override
    public <T> T first(Class<T> containerType) {
        throw new UnsupportedOperationException("Not Yet Implemented!");
    }

    @Override
    public <ContainerType> ContainerType list(Class<ContainerType> containerType) {
        throw new UnsupportedOperationException("Not Yet Implemented!");
    }

    @Override
    public List<Type> list(int maxRows) {
        try {
            int idx = 0;
            ArrayList<Type> resultList = new ArrayList<Type>();
            if (this.results != null && ++idx <= maxRows && !this.results.isClosed()) {
                int index = 0;
                while (this.results.next()) {
                    resultList.add(this.mapper.map(index++, this.results, this.context));
                }
            }
            ArrayList<Type> arrayList = resultList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new ResultSetException("Exception thrown while attempting to traverse the result set", e, this.context);
        }
        finally {
            this.jdbiStatement.cleanup();
        }
    }

    @Override
    public List<Type> list() {
        return this.list(Integer.MAX_VALUE);
    }

    @Override
    public ResultIterator<Type> iterator() {
        try {
            return new ResultSetResultIterator<Type>(this.mapper, this.jdbiStatement, this.stmt, this.context);
        }
        catch (SQLException e) {
            throw new ResultSetException("Exception thrown while attempting to traverse the result set", e, this.context);
        }
    }

    public <AccumulatorType> AccumulatorType fold(AccumulatorType accumulator, Folder2<AccumulatorType> folder) {
        try {
            AccumulatorType value = accumulator;
            if (this.results != null && !this.results.isClosed()) {
                while (this.results.next()) {
                    value = folder.fold(value, this.results, this.context);
                }
            }
            AccumulatorType AccumulatorType = value;
            return AccumulatorType;
        }
        catch (SQLException e) {
            throw new ResultSetException("Exception thrown while attempting to traverse the result set", e, this.context);
        }
        finally {
            this.jdbiStatement.cleanup();
        }
    }
}

