/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.skife.jdbi.v2.BaseStatement;
import org.skife.jdbi.v2.Cleanables;
import org.skife.jdbi.v2.QueryResultMunger;
import org.skife.jdbi.v2.exceptions.NoResultsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class QueryResultSetMunger<T>
implements QueryResultMunger<T> {
    private BaseStatement stmt;

    QueryResultSetMunger(BaseStatement stmt) {
        this.stmt = stmt;
    }

    @Override
    public final T munge(Statement results) throws SQLException {
        ResultSet rs = results.getResultSet();
        if (rs == null) {
            throw new NoResultsException("Query did not have a result set, perhaps you meant update?", this.stmt.getContext());
        }
        this.stmt.addCleanable(Cleanables.forResultSet(rs));
        return this.munge(rs);
    }

    protected abstract T munge(ResultSet var1) throws SQLException;
}

