/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import com.fasterxml.classmate.members.ResolvedMethod;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.cglib.proxy.MethodProxy;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.sqlobject.CustomizingStatementHandler;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlObject;
import org.skife.jdbi.v2.sqlobject.customizers.BatchChunkSize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BatchHandler
extends CustomizingStatementHandler {
    private final String sql;
    private final boolean transactional;
    private final ChunkSizeFunction batchChunkSize;

    public BatchHandler(Class<?> sqlObjectType, ResolvedMethod method) {
        super(sqlObjectType, method);
        Method raw_method = (Method)method.getRawMember();
        SqlBatch anno = raw_method.getAnnotation(SqlBatch.class);
        this.sql = SqlObject.getSql(anno, raw_method);
        this.transactional = anno.transactional();
        this.batchChunkSize = this.determineBatchChunkSize(sqlObjectType, raw_method);
    }

    private ChunkSizeFunction determineBatchChunkSize(Class<?> sqlObjectType, Method raw_method) {
        int index_of_batch_chunk_size_annotation_on_parameter = this.findBatchChunkSizeFromParam(raw_method);
        if (index_of_batch_chunk_size_annotation_on_parameter >= 0) {
            return new ParamBasedChunkSizeFunction(index_of_batch_chunk_size_annotation_on_parameter);
        }
        if (raw_method.isAnnotationPresent(BatchChunkSize.class)) {
            int size = raw_method.getAnnotation(BatchChunkSize.class).value();
            if (size <= 0) {
                throw new IllegalArgumentException("Batch chunk size must be >= 0");
            }
            return new ConstantChunkSizeFunction(size);
        }
        if (sqlObjectType.isAnnotationPresent(BatchChunkSize.class)) {
            int size = ((BatchChunkSize)BatchChunkSize.class.cast(sqlObjectType.getAnnotation(BatchChunkSize.class))).value();
            return new ConstantChunkSizeFunction(size);
        }
        return new ConstantChunkSizeFunction(Integer.MAX_VALUE);
    }

    private int findBatchChunkSizeFromParam(Method raw_method) {
        Annotation[][] param_annos = raw_method.getParameterAnnotations();
        for (int i = 0; i < param_annos.length; ++i) {
            Annotation[] annos;
            for (Annotation anno : annos = param_annos[i]) {
                if (!anno.annotationType().isAssignableFrom(BatchChunkSize.class)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object invoke(HandleDing h, Object target, Object[] args, MethodProxy mp) {
        Object[] _args;
        Handle handle = h.getHandle();
        ArrayList<Iterator> extras = new ArrayList<Iterator>();
        for (final Object arg : args) {
            if (arg instanceof Iterable) {
                extras.add(((Iterable)arg).iterator());
                continue;
            }
            if (arg instanceof Iterator) {
                extras.add((Iterator)arg);
                continue;
            }
            if (arg.getClass().isArray()) {
                extras.add(Arrays.asList((Object[])arg).iterator());
                continue;
            }
            extras.add(new Iterator(){

                public boolean hasNext() {
                    return true;
                }

                @SuppressFBWarnings(value={"IT_NO_SUCH_ELEMENT"})
                public Object next() {
                    return arg;
                }

                public void remove() {
                }
            });
        }
        int processed = 0;
        ArrayList<int[]> rs_parts = new ArrayList<int[]>();
        PreparedBatch batch = handle.prepareBatch(this.sql);
        this.populateSqlObjectData((ConcreteStatementContext)batch.getContext());
        this.applyCustomizers(batch, args);
        int chunk_size = this.batchChunkSize.call(args);
        while ((_args = BatchHandler.next(extras)) != null) {
            PreparedBatchPart part = batch.add();
            this.applyBinders(part, _args);
            if (++processed != chunk_size) continue;
            processed = 0;
            rs_parts.add(this.executeBatch(handle, batch));
            batch = handle.prepareBatch(this.sql);
            this.populateSqlObjectData((ConcreteStatementContext)batch.getContext());
            this.applyCustomizers(batch, args);
        }
        rs_parts.add(this.executeBatch(handle, batch));
        int end_size = 0;
        for (int[] rs_part : rs_parts) {
            end_size += rs_part.length;
        }
        int[] rs = new int[end_size];
        int offset = 0;
        for (int[] rs_part : rs_parts) {
            System.arraycopy(rs_part, 0, rs, offset, rs_part.length);
            offset += rs_part.length;
        }
        return rs;
    }

    private int[] executeBatch(Handle handle, final PreparedBatch batch) {
        if (!handle.isInTransaction() && this.transactional) {
            return handle.inTransaction(new TransactionCallback<int[]>(){

                @Override
                public int[] inTransaction(Handle conn, TransactionStatus status) throws Exception {
                    return batch.execute();
                }
            });
        }
        return batch.execute();
    }

    private static Object[] next(List<Iterator> args) {
        ArrayList rs = new ArrayList();
        for (Iterator arg : args) {
            if (arg.hasNext()) {
                rs.add(arg.next());
                continue;
            }
            return null;
        }
        return rs.toArray();
    }

    private static class ParamBasedChunkSizeFunction
    implements ChunkSizeFunction {
        private final int index;

        ParamBasedChunkSizeFunction(int index) {
            this.index = index;
        }

        public int call(Object[] args) {
            return (Integer)args[this.index];
        }
    }

    private static class ConstantChunkSizeFunction
    implements ChunkSizeFunction {
        private final int value;

        ConstantChunkSizeFunction(int value) {
            this.value = value;
        }

        public int call(Object[] args) {
            return this.value;
        }
    }

    private static interface ChunkSizeFunction {
        public int call(Object[] var1);
    }
}

