/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.statement;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.BaseStatementCustomizer;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface SmartFetchSize {
    public int value() default 0;

    public boolean shouldStream() default false;

    public static final class SmartFetchSizeCustomizer
    extends BaseStatementCustomizer {
        private static final String MYSQL = "MySQL";
        private final int fetchSize;
        private final boolean shouldStream;

        public SmartFetchSizeCustomizer(int fetchSize, boolean shouldStream) {
            this.fetchSize = fetchSize;
            this.shouldStream = shouldStream;
        }

        public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
            stmt.setFetchSize(this.fetchSize);
            if (this.shouldStream) {
                if (ctx != null && ctx.getConnection() != null && ctx.getConnection().getMetaData() != null && MYSQL.equalsIgnoreCase(ctx.getConnection().getMetaData().getDatabaseProductName())) {
                    try {
                        stmt.setFetchSize(Integer.MIN_VALUE);
                    }
                    catch (SQLException e) {
                        stmt.setFetchSize(0);
                    }
                } else {
                    stmt.setFetchSize(0);
                }
            } else {
                stmt.setFetchSize(this.fetchSize);
            }
        }
    }

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            final SmartFetchSize fs = (SmartFetchSize)annotation;
            return new SqlStatementCustomizer(){

                public void apply(SQLStatement q) throws SQLException {
                    Factory.this.setFetchSize((Query)q, fs.value(), fs.shouldStream());
                }
            };
        }

        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            final SmartFetchSize fs = (SmartFetchSize)annotation;
            return new SqlStatementCustomizer(){

                public void apply(SQLStatement q) throws SQLException {
                    Factory.this.setFetchSize((Query)q, fs.value(), fs.shouldStream());
                }
            };
        }

        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            final Integer va = (Integer)arg;
            return new SqlStatementCustomizer(){

                public void apply(SQLStatement q) throws SQLException {
                    Factory.this.setFetchSize((Query)q, va, false);
                }
            };
        }

        private Query setFetchSize(Query query, Integer value, boolean shouldStream) {
            query.addStatementCustomizer(new SmartFetchSizeCustomizer(value, shouldStream));
            return query;
        }
    }
}

