/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.transaction;

import org.killbill.commons.jdbi.notification.DatabaseTransactionEvent;
import org.killbill.commons.jdbi.notification.DatabaseTransactionEventType;
import org.killbill.commons.jdbi.notification.DatabaseTransactionNotificationApi;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.skife.jdbi.v2.tweak.transactions.DelegatingTransactionHandler;
import org.skife.jdbi.v2.tweak.transactions.LocalTransactionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationTransactionHandler
extends DelegatingTransactionHandler
implements TransactionHandler {
    private static final Logger logger = LoggerFactory.getLogger(NotificationTransactionHandler.class);
    private final DatabaseTransactionNotificationApi transactionNotificationApi;

    public NotificationTransactionHandler(DatabaseTransactionNotificationApi transactionNotificationApi) {
        super(new LocalTransactionHandler());
        this.transactionNotificationApi = transactionNotificationApi;
    }

    public void commit(Handle handle) {
        this.getDelegate().commit(handle);
        this.dispatchEvent(new DatabaseTransactionEvent(DatabaseTransactionEventType.COMMIT));
    }

    public void rollback(Handle handle) {
        this.getDelegate().rollback(handle);
        this.dispatchEvent(new DatabaseTransactionEvent(DatabaseTransactionEventType.ROLLBACK));
    }

    private void dispatchEvent(DatabaseTransactionEvent event) {
        try {
            this.transactionNotificationApi.dispatchNotification(event);
        }
        catch (Exception e) {
            logger.warn("Failed to notify for event {}", (Object)event);
        }
    }
}

