/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.NamedArgumentFinder;

class BeanPropertyArguments
implements NamedArgumentFinder {
    private final Object bean;
    private final StatementContext ctx;
    private final Foreman foreman;
    private BeanInfo info;

    BeanPropertyArguments(Object bean, StatementContext ctx, Foreman foreman) {
        this.bean = bean;
        this.ctx = ctx;
        this.foreman = foreman;
        try {
            this.info = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new UnableToCreateStatementException("Failed to introspect object which is supposed ot be used to set named args for a statement via JavaBean properties", e, ctx);
        }
    }

    public Argument find(String name) {
        for (PropertyDescriptor descriptor : this.info.getPropertyDescriptors()) {
            if (!descriptor.getName().equals(name)) continue;
            try {
                return this.foreman.waffle(descriptor.getReadMethod().getReturnType(), descriptor.getReadMethod().invoke(this.bean, new Object[0]), this.ctx);
            }
            catch (IllegalAccessException e) {
                throw new UnableToCreateStatementException(String.format("Access excpetion invoking getter for bean property [%s] on [%s]", name, this.bean), e, this.ctx);
            }
            catch (InvocationTargetException e) {
                throw new UnableToCreateStatementException(String.format("Invocation target exception invoking getter for bean property [%s] on [%s]", name, this.bean), e, this.ctx);
            }
        }
        return null;
    }

    public String toString() {
        return "{lazy bean proprty arguments \"" + this.bean + "\"";
    }
}

