/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

class FloatArgument
implements Argument {
    private final Float value;

    FloatArgument(Float value) {
        this.value = value;
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.value != null) {
            statement.setFloat(position, this.value.floatValue());
        } else {
            statement.setNull(position, 6);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

