/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.LinkedHashMap;
import java.util.Map;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.NamedArgumentFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapArguments
implements NamedArgumentFinder {
    private final Foreman foreman;
    private final StatementContext ctx;
    private final Map<String, ? extends Object> args;

    MapArguments(Foreman foreman, StatementContext ctx, Map<String, ? extends Object> args) {
        this.foreman = foreman;
        this.ctx = ctx;
        this.args = args;
    }

    @Override
    public Argument find(String name) {
        if (this.args.containsKey(name)) {
            Object argument = this.args.get(name);
            Class argumentClass = argument == null ? Object.class : argument.getClass();
            return this.foreman.waffle(argumentClass, argument, this.ctx);
        }
        return null;
    }

    public String toString() {
        return new LinkedHashMap<String, Object>(this.args).toString();
    }
}

