/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.StatementCustomizers;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface FetchDirection {
    public int value();

    public static class FetchDirectionSqlStatementCustomizer
    implements SqlStatementCustomizer {
        private final Integer direction;

        public FetchDirectionSqlStatementCustomizer(Integer direction) {
            this.direction = direction;
        }

        public void apply(SQLStatement q) throws SQLException {
            q.addStatementCustomizer(new StatementCustomizers.FetchDirectionStatementCustomizer(this.direction));
        }
    }

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForParameter(Annotation annotation, Object arg) {
            return new FetchDirectionSqlStatementCustomizer((Integer)arg);
        }

        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            FetchDirection fs = (FetchDirection)annotation;
            return new FetchDirectionSqlStatementCustomizer(fs.value());
        }

        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            FetchDirection fs = (FetchDirection)annotation;
            return new FetchDirectionSqlStatementCustomizer(fs.value());
        }

        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            return new FetchDirectionSqlStatementCustomizer((Integer)arg);
        }
    }
}

