/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.skife.jdbi.v2.BaseStatement;
import org.skife.jdbi.v2.BeanMapper;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.ContainerBuilder;
import org.skife.jdbi.v2.ContainerFactoryRegistry;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder;
import org.skife.jdbi.v2.Folder2;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.MappingRegistry;
import org.skife.jdbi.v2.QueryResultMunger;
import org.skife.jdbi.v2.QueryResultSetMunger;
import org.skife.jdbi.v2.RegisteredMapper;
import org.skife.jdbi.v2.ResultBearing;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.ResultSetResultIterator;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.StatementCustomizers;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.UnwrappedSingleValue;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementBuilder;
import org.skife.jdbi.v2.tweak.StatementCustomizer;
import org.skife.jdbi.v2.tweak.StatementLocator;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public class Query<ResultType>
extends SQLStatement<Query<ResultType>>
implements ResultBearing<ResultType> {
    private final ResultSetMapper<ResultType> mapper;
    private final MappingRegistry mappingRegistry;

    Query(Binding params, ResultSetMapper<ResultType> mapper, StatementLocator locator, StatementRewriter statementRewriter, Handle handle, StatementBuilder cache, String sql, ConcreteStatementContext ctx, SQLLog log, TimingCollector timingCollector, Collection<StatementCustomizer> customizers, MappingRegistry mappingRegistry, Foreman foreman, ContainerFactoryRegistry containerFactoryRegistry) {
        super(params, locator, statementRewriter, handle, cache, sql, ctx, log, timingCollector, customizers, foreman, containerFactoryRegistry);
        this.mapper = mapper;
        this.mappingRegistry = mappingRegistry.createChild();
    }

    @Override
    public List<ResultType> list() {
        return this.list(List.class);
    }

    @Override
    public <ContainerType> ContainerType list(Class<ContainerType> containerType) {
        ContainerBuilder builder = this.getContainerMapperRegistry().createBuilderFor(containerType);
        return this.fold(builder, new Folder3<ContainerBuilder<ContainerType>, ResultType>(){

            @Override
            public ContainerBuilder<ContainerType> fold(ContainerBuilder<ContainerType> accumulator, ResultType rs, FoldController ctl, StatementContext ctx) throws SQLException {
                accumulator.add(rs);
                return accumulator;
            }
        }).build();
    }

    @Override
    public List<ResultType> list(final int maxRows) {
        try {
            List list = (List)this.internalExecute(new QueryResultSetMunger<List<ResultType>>(this){

                @Override
                public List<ResultType> munge(ResultSet rs) throws SQLException {
                    ArrayList result_list = new ArrayList();
                    int index = 0;
                    while (rs.next() && index < maxRows) {
                        result_list.add(Query.this.mapper.map(index++, rs, Query.this.getContext()));
                    }
                    return result_list;
                }
            });
            return list;
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <AccumulatorType> AccumulatorType fold(AccumulatorType accumulator, final Folder2<AccumulatorType> folder) {
        final AtomicReference<AccumulatorType> acc = new AtomicReference<AccumulatorType>(accumulator);
        try {
            this.internalExecute(new QueryResultSetMunger<Void>((BaseStatement)this){

                @Override
                public Void munge(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        acc.set(folder.fold(acc.get(), rs, Query.this.getContext()));
                    }
                    return null;
                }
            });
            AccumulatorType AccumulatorType = acc.get();
            return AccumulatorType;
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <AccumulatorType> AccumulatorType fold(final AccumulatorType accumulator, final Folder3<AccumulatorType, ResultType> folder) {
        try {
            Object Result = this.internalExecute(new QueryResultSetMunger<AccumulatorType>(this){
                private int idx;
                private AccumulatorType ac;
                {
                    super(stmt);
                    this.idx = 0;
                    this.ac = accumulator;
                }

                @Override
                protected AccumulatorType munge(ResultSet rs) throws SQLException {
                    FoldController ctl = new FoldController(rs);
                    while (!ctl.isAborted() && rs.next()) {
                        Object row_value = Query.this.mapper.map(this.idx++, rs, Query.this.getContext());
                        this.ac = folder.fold(this.ac, row_value, ctl, Query.this.getContext());
                    }
                    return this.ac;
                }
            });
            return (AccumulatorType)Result;
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <AccumulatorType> AccumulatorType fold(AccumulatorType accumulator, final Folder<AccumulatorType> folder) {
        final AtomicReference<AccumulatorType> acc = new AtomicReference<AccumulatorType>(accumulator);
        try {
            this.internalExecute(new QueryResultSetMunger<Void>((BaseStatement)this){

                @Override
                public Void munge(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        acc.set(folder.fold(acc.get(), rs));
                    }
                    return null;
                }
            });
            AccumulatorType AccumulatorType = acc.get();
            return AccumulatorType;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public ResultIterator<ResultType> iterator() {
        return (ResultIterator)this.internalExecute(new QueryResultMunger<ResultIterator<ResultType>>(){

            @Override
            public ResultIterator<ResultType> munge(Statement stmt) throws SQLException {
                return new ResultSetResultIterator(Query.this.mapper, Query.this, stmt, Query.this.getContext());
            }
        });
    }

    @Override
    public ResultType first() {
        return (ResultType)this.first(UnwrappedSingleValue.class);
    }

    @Override
    public <T> T first(Class<T> containerType) {
        ContainerBuilder builder = this.getContainerMapperRegistry().createBuilderFor(containerType);
        return (T)this.fold(builder, new Folder3<ContainerBuilder, ResultType>(){

            @Override
            public ContainerBuilder fold(ContainerBuilder accumulator, ResultType rs, FoldController control, StatementContext ctx) throws SQLException {
                accumulator.add(rs);
                control.abort();
                return accumulator;
            }
        }).build();
    }

    public <Type> Query<Type> map(Class<Type> resultType) {
        return this.map(new BeanMapper<Type>(resultType));
    }

    public <T> Query<T> mapTo(Class<T> resultType) {
        return this.map(new RegisteredMapper<T>(resultType, this.mappingRegistry));
    }

    public <T> Query<T> map(ResultSetMapper<T> mapper) {
        return new Query<T>(this.getParameters(), mapper, this.getStatementLocator(), this.getRewriter(), this.getHandle(), this.getStatementBuilder(), this.getSql(), this.getConcreteContext(), this.getLog(), this.getTimingCollector(), this.getStatementCustomizers(), this.mappingRegistry.createChild(), this.getForeman().createChild(), this.getContainerMapperRegistry().createChild());
    }

    public Query<ResultType> setFetchSize(int fetchSize) {
        this.addStatementCustomizer(new StatementCustomizers.FetchSizeCustomizer(fetchSize));
        return this;
    }

    public Query<ResultType> setMaxRows(int maxRows) {
        this.addStatementCustomizer(new StatementCustomizers.MaxRowsCustomizer(maxRows));
        return this;
    }

    public Query<ResultType> setMaxFieldSize(int maxFields) {
        this.addStatementCustomizer(new StatementCustomizers.MaxFieldSizeCustomizer(maxFields));
        return this;
    }

    public Query<ResultType> fetchReverse() {
        this.setFetchDirection(1001);
        return this;
    }

    public Query<ResultType> fetchForward() {
        this.setFetchDirection(1000);
        return this;
    }

    public void registerMapper(ResultSetMapper m) {
        throw new UnsupportedOperationException("[OPTIMIZATION] Registering a custom ResultSetMapper on a Query is disabled");
    }

    public void registerMapper(ResultSetMapperFactory m) {
        throw new UnsupportedOperationException("[OPTIMIZATION] Registering a custom ResultSetMapperFactory on a Query is disabled");
    }
}

