/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.skife.jdbi.v2.BaseStatement;
import org.skife.jdbi.v2.BeanPropertyArguments;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.BooleanIntegerArgument;
import org.skife.jdbi.v2.Call;
import org.skife.jdbi.v2.CharacterStreamArgument;
import org.skife.jdbi.v2.Cleanables;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.ContainerFactoryRegistry;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.InputStreamArgument;
import org.skife.jdbi.v2.MapArguments;
import org.skife.jdbi.v2.NullArgument;
import org.skife.jdbi.v2.QueryResultMunger;
import org.skife.jdbi.v2.SqlTypeArgument;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.StatementCustomizers;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.TransactionState;
import org.skife.jdbi.v2.exceptions.ResultSetException;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ContainerFactory;
import org.skife.jdbi.v2.tweak.NamedArgumentFinder;
import org.skife.jdbi.v2.tweak.RewrittenStatement;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementBuilder;
import org.skife.jdbi.v2.tweak.StatementCustomizer;
import org.skife.jdbi.v2.tweak.StatementLocator;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public abstract class SQLStatement<SelfType extends SQLStatement<SelfType>>
extends BaseStatement {
    private final Binding params;
    private final Handle handle;
    private final String sql;
    private final StatementBuilder statementBuilder;
    private final Collection<StatementCustomizer> customizers = new ArrayList<StatementCustomizer>();
    private StatementLocator locator;
    private StatementRewriter rewriter;
    private RewrittenStatement rewritten;
    private PreparedStatement stmt;
    private final SQLLog log;
    private final TimingCollector timingCollector;
    private final ContainerFactoryRegistry containerMapperRegistry;

    SQLStatement(Binding params, StatementLocator locator, StatementRewriter rewriter, Handle handle, StatementBuilder statementBuilder, String sql, ConcreteStatementContext ctx, SQLLog log, TimingCollector timingCollector, Collection<StatementCustomizer> statementCustomizers, Foreman foreman, ContainerFactoryRegistry containerFactoryRegistry) {
        super(ctx, foreman);
        this.addCustomizers(statementCustomizers);
        this.log = log;
        this.statementBuilder = statementBuilder;
        this.rewriter = rewriter;
        this.handle = handle;
        this.sql = sql;
        this.timingCollector = timingCollector;
        this.params = params;
        this.locator = locator;
        this.containerMapperRegistry = containerFactoryRegistry.createChild();
        ctx.setConnection(handle.getConnection());
        ctx.setRawSql(sql);
        ctx.setBinding(params);
    }

    protected ContainerFactoryRegistry getContainerMapperRegistry() {
        return this.containerMapperRegistry;
    }

    public SelfType registerContainerFactory(ContainerFactory<?> containerFactory) {
        this.getContainerMapperRegistry().register(containerFactory);
        return (SelfType)this;
    }

    public SelfType registerArgumentFactory(ArgumentFactory<?> argumentFactory) {
        throw new UnsupportedOperationException("[OPTIMIZATION] Registering a custom ArgumentFactory on a SQLStatement is disabled");
    }

    public void setStatementLocator(StatementLocator locator) {
        this.locator = locator;
    }

    public SelfType setStatementLocator2(StatementLocator locator) {
        this.setStatementLocator(locator);
        return (SelfType)this;
    }

    public void setStatementRewriter(StatementRewriter rewriter) {
        this.rewriter = rewriter;
    }

    public SelfType setStatementRewriter2(StatementRewriter rewriter) {
        this.setStatementRewriter(rewriter);
        return (SelfType)this;
    }

    public SelfType define(String key, Object value) {
        this.getContext().setAttribute(key, value);
        return (SelfType)this;
    }

    public SelfType define(Map<String, ? extends Object> values) {
        StatementContext context = this.getContext();
        if (values != null) {
            for (Map.Entry<String, ? extends Object> entry : values.entrySet()) {
                context.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return (SelfType)this;
    }

    public SelfType addStatementCustomizer(StatementCustomizer customizer) {
        super.addCustomizer(customizer);
        return (SelfType)this;
    }

    private boolean verifyOurNastyDowncastIsOkay() {
        if (this.getClass().getTypeParameters().length == 0) {
            return true;
        }
        Class<?> parameterized_type = this.getClass().getTypeParameters()[0].getGenericDeclaration();
        return parameterized_type.isAssignableFrom(this.getClass());
    }

    protected StatementBuilder getStatementBuilder() {
        return this.statementBuilder;
    }

    protected StatementLocator getStatementLocator() {
        return this.locator;
    }

    protected StatementRewriter getRewriter() {
        return this.rewriter;
    }

    protected Binding getParams() {
        return this.params;
    }

    protected Handle getHandle() {
        return this.handle;
    }

    protected String getSql() {
        return this.sql;
    }

    protected Binding getParameters() {
        return this.params;
    }

    public SelfType setQueryTimeout(int seconds) {
        return this.addStatementCustomizer(new StatementCustomizers.QueryTimeoutCustomizer(seconds));
    }

    public SelfType cleanupHandle() {
        super.addCleanable(Cleanables.forHandle(this.handle, TransactionState.ROLLBACK));
        return (SelfType)this;
    }

    public SelfType cleanupHandle(TransactionState state) {
        super.addCleanable(Cleanables.forHandle(this.handle, state));
        return (SelfType)this;
    }

    public SelfType bind(int position, Argument argument) {
        this.getParams().addPositional(position, argument);
        return (SelfType)this;
    }

    public SelfType bind(String name, Argument argument) {
        this.getParams().addNamed(name, argument);
        return (SelfType)this;
    }

    public SelfType bindFromProperties(Object o) {
        return this.bindNamedArgumentFinder(new BeanPropertyArguments(o, this.getContext(), this.getForeman()));
    }

    public SelfType bindFromMap(Map<String, ? extends Object> args) {
        if (args != null) {
            return this.bindNamedArgumentFinder(new MapArguments(this.getForeman(), this.getContext(), args));
        }
        return (SelfType)this;
    }

    public SelfType bindNamedArgumentFinder(NamedArgumentFinder namedArgumentFinder) {
        if (namedArgumentFinder != null) {
            this.getParams().addNamedArgumentFinder(namedArgumentFinder);
        }
        return (SelfType)this;
    }

    public final SelfType bind(int position, Character value) {
        return this.bind(position, this.getForeman().waffle(Character.class, value, this.getContext()));
    }

    public final SelfType bind(String name, Character value) {
        return this.bind(name, this.getForeman().waffle(Character.class, value, this.getContext()));
    }

    public final SelfType bind(int position, String value) {
        return this.bind(position, this.getForeman().waffle(String.class, value, this.getContext()));
    }

    public final SelfType bind(String name, String value) {
        return this.bind(name, this.getForeman().waffle(String.class, value, this.getContext()));
    }

    public final SelfType bind(int position, int value) {
        return this.bind(position, this.getForeman().waffle(Integer.TYPE, value, this.getContext()));
    }

    public final SelfType bind(int position, Integer value) {
        return this.bind(position, this.getForeman().waffle(Integer.class, value, this.getContext()));
    }

    public final SelfType bind(String name, int value) {
        return this.bind(name, this.getForeman().waffle(Integer.TYPE, value, this.getContext()));
    }

    public final SelfType bind(String name, Integer value) {
        return this.bind(name, this.getForeman().waffle(Integer.class, value, this.getContext()));
    }

    public final SelfType bind(int position, char value) {
        return this.bind(position, this.getForeman().waffle(Character.TYPE, Character.valueOf(value), this.getContext()));
    }

    public final SelfType bind(String name, char value) {
        return this.bind(name, this.getForeman().waffle(Character.TYPE, Character.valueOf(value), this.getContext()));
    }

    public final SelfType bindASCIIStream(int position, InputStream value, int length) {
        return this.bind(position, (Argument)new InputStreamArgument(value, length, true));
    }

    public final SelfType bindASCIIStream(String name, InputStream value, int length) {
        return this.bind(name, (Argument)new InputStreamArgument(value, length, true));
    }

    public final SelfType bind(int position, BigDecimal value) {
        return this.bind(position, this.getForeman().waffle(BigDecimal.class, value, this.getContext()));
    }

    public final SelfType bind(String name, BigDecimal value) {
        return this.bind(name, this.getForeman().waffle(BigDecimal.class, value, this.getContext()));
    }

    public final SelfType bindBinaryStream(int position, InputStream value, int length) {
        return this.bind(position, (Argument)new InputStreamArgument(value, length, false));
    }

    public final SelfType bindBinaryStream(String name, InputStream value, int length) {
        return this.bind(name, (Argument)new InputStreamArgument(value, length, false));
    }

    public final SelfType bind(int position, Blob value) {
        return this.bind(position, this.getForeman().waffle(Blob.class, value, this.getContext()));
    }

    public final SelfType bind(String name, Blob value) {
        return this.bind(name, this.getForeman().waffle(Blob.class, value, this.getContext()));
    }

    public final SelfType bind(int position, boolean value) {
        return this.bind(position, this.getForeman().waffle(Boolean.TYPE, value, this.getContext()));
    }

    public final SelfType bind(int position, Boolean value) {
        return this.bind(position, this.getForeman().waffle(Boolean.class, value, this.getContext()));
    }

    public final SelfType bind(String name, boolean value) {
        return this.bind(name, this.getForeman().waffle(Boolean.TYPE, value, this.getContext()));
    }

    public final SelfType bind(String name, Boolean value) {
        return this.bind(name, this.getForeman().waffle(Boolean.class, value, this.getContext()));
    }

    public final SelfType bindAsInt(int position, boolean value) {
        return this.bind(position, (Argument)new BooleanIntegerArgument(value));
    }

    public final SelfType bindAsInt(int position, Boolean value) {
        if (value != null) {
            return this.bind(position, (Argument)new BooleanIntegerArgument(value));
        }
        return this.bind(position, (Argument)new NullArgument(4));
    }

    public final SelfType bindAsInt(String name, boolean value) {
        return this.bind(name, (Argument)new BooleanIntegerArgument(value));
    }

    public final SelfType bindAsInt(String name, Boolean value) {
        if (value != null) {
            return this.bind(name, (Argument)new BooleanIntegerArgument(value));
        }
        return this.bind(name, (Argument)new NullArgument(4));
    }

    public final SelfType bind(int position, byte value) {
        return this.bind(position, this.getForeman().waffle(Byte.TYPE, value, this.getContext()));
    }

    public final SelfType bind(int position, Byte value) {
        return this.bind(position, this.getForeman().waffle(Byte.class, value, this.getContext()));
    }

    public final SelfType bind(String name, byte value) {
        return this.bind(name, this.getForeman().waffle(Byte.TYPE, value, this.getContext()));
    }

    public final SelfType bind(String name, Byte value) {
        return this.bind(name, this.getForeman().waffle(Byte.class, value, this.getContext()));
    }

    public final SelfType bind(int position, byte[] value) {
        return this.bind(position, this.getForeman().waffle(byte[].class, value, this.getContext()));
    }

    public final SelfType bind(String name, byte[] value) {
        return this.bind(name, this.getForeman().waffle(byte[].class, value, this.getContext()));
    }

    public final SelfType bind(int position, Reader value, int length) {
        return this.bind(position, (Argument)new CharacterStreamArgument(value, length));
    }

    public final SelfType bind(String name, Reader value, int length) {
        return this.bind(name, (Argument)new CharacterStreamArgument(value, length));
    }

    public final SelfType bind(int position, Clob value) {
        return this.bind(position, this.getForeman().waffle(Clob.class, value, this.getContext()));
    }

    public final SelfType bind(String name, Clob value) {
        return this.bind(name, this.getForeman().waffle(Clob.class, value, this.getContext()));
    }

    public final SelfType bind(int position, Date value) {
        return this.bind(position, this.getForeman().waffle(Date.class, value, this.getContext()));
    }

    public final SelfType bind(String name, Date value) {
        return this.bind(name, this.getForeman().waffle(Date.class, value, this.getContext()));
    }

    public final SelfType bind(int position, java.util.Date value) {
        return this.bind(position, this.getForeman().waffle(java.util.Date.class, value, this.getContext()));
    }

    public final SelfType bind(String name, java.util.Date value) {
        return this.bind(name, this.getForeman().waffle(java.util.Date.class, value, this.getContext()));
    }

    public final SelfType bind(int position, double value) {
        return this.bind(position, this.getForeman().waffle(Double.TYPE, value, this.getContext()));
    }

    public final SelfType bind(int position, Double value) {
        return this.bind(position, this.getForeman().waffle(Double.class, value, this.getContext()));
    }

    public final SelfType bind(String name, double value) {
        return this.bind(name, this.getForeman().waffle(Double.TYPE, value, this.getContext()));
    }

    public final SelfType bind(String name, Double value) {
        return this.bind(name, this.getForeman().waffle(Double.class, value, this.getContext()));
    }

    public final SelfType bind(int position, float value) {
        return this.bind(position, this.getForeman().waffle(Float.TYPE, Float.valueOf(value), this.getContext()));
    }

    public final SelfType bind(int position, Float value) {
        return this.bind(position, this.getForeman().waffle(Float.class, value, this.getContext()));
    }

    public final SelfType bind(String name, float value) {
        return this.bind(name, this.getForeman().waffle(Float.TYPE, Float.valueOf(value), this.getContext()));
    }

    public final SelfType bind(String name, Float value) {
        return this.bind(name, this.getForeman().waffle(Float.class, value, this.getContext()));
    }

    public final SelfType bind(int position, long value) {
        return this.bind(position, this.getForeman().waffle(Long.TYPE, value, this.getContext()));
    }

    public final SelfType bind(int position, Long value) {
        if (value != null) {
            return this.bind(position, this.getForeman().waffle(Long.class, value, this.getContext()));
        }
        return this.bind(position, (Argument)new NullArgument(-5));
    }

    public final SelfType bind(String name, long value) {
        return this.bind(name, this.getForeman().waffle(Long.TYPE, value, this.getContext()));
    }

    public final SelfType bind(String name, Long value) {
        return this.bind(name, this.getForeman().waffle(Long.class, value, this.getContext()));
    }

    public final SelfType bind(int position, Short value) {
        return this.bind(position, this.getForeman().waffle(Short.class, value, this.getContext()));
    }

    public final SelfType bind(int position, short value) {
        return this.bind(position, this.getForeman().waffle(Short.TYPE, value, this.getContext()));
    }

    public final SelfType bind(String name, short value) {
        return this.bind(name, this.getForeman().waffle(Short.TYPE, value, this.getContext()));
    }

    public final SelfType bind(String name, Short value) {
        return this.bind(name, this.getForeman().waffle(Short.TYPE, value, this.getContext()));
    }

    public final SelfType bind(int position, Object value) {
        return this.bind(position, this.getForeman().waffle(value != null ? value.getClass() : Object.class, value, this.getContext()));
    }

    public final SelfType bind(String name, Object value) {
        return this.bind(name, this.getForeman().waffle(value != null ? value.getClass() : Object.class, value, this.getContext()));
    }

    public final SelfType bind(int position, Time value) {
        return this.bind(position, this.getForeman().waffle(Time.class, value, this.getContext()));
    }

    public final SelfType bind(String name, Time value) {
        return this.bind(name, this.getForeman().waffle(Time.class, value, this.getContext()));
    }

    public final SelfType bind(int position, Timestamp value) {
        return this.bind(position, this.getForeman().waffle(Timestamp.class, value, this.getContext()));
    }

    public final SelfType bind(String name, Timestamp value) {
        return this.bind(name, this.getForeman().waffle(Timestamp.class, value, this.getContext()));
    }

    public final SelfType bind(int position, URL value) {
        return this.bind(position, this.getForeman().waffle(URL.class, value, this.getContext()));
    }

    public final SelfType bind(String name, URL value) {
        return this.bind(name, this.getForeman().waffle(URL.class, value, this.getContext()));
    }

    public final SelfType dynamicBind(Class<?> argumentClass, String name, Object value) {
        return this.bind(name, this.getForeman().waffle(argumentClass, value, this.getContext()));
    }

    public final SelfType bindNull(String name, int sqlType) {
        return this.bind(name, (Argument)new NullArgument(sqlType));
    }

    public final SelfType bindNull(int position, int sqlType) {
        return this.bind(position, (Argument)new NullArgument(sqlType));
    }

    public final SelfType bindBySqlType(String name, Object value, int sqlType) {
        return this.bind(name, (Argument)new SqlTypeArgument(value, sqlType));
    }

    public final SelfType bindBySqlType(int position, Object value, int sqlType) {
        return this.bind(position, (Argument)new SqlTypeArgument(value, sqlType));
    }

    private String wrapLookup(String sql) {
        try {
            return this.locator.locate(sql, this.getContext());
        }
        catch (Exception e) {
            throw new UnableToCreateStatementException("Exception thrown while looking for statement", e, this.getContext());
        }
    }

    protected <Result> Result internalExecute(QueryResultMunger<Result> munger) {
        String located_sql = this.wrapLookup(this.sql);
        this.getConcreteContext().setLocatedSql(located_sql);
        this.rewritten = this.rewriter.rewrite(located_sql, this.getParameters(), this.getContext());
        this.getConcreteContext().setRewrittenSql(this.rewritten.getSql());
        try {
            this.stmt = this.getClass().isAssignableFrom(Call.class) ? this.statementBuilder.createCall(this.handle.getConnection(), this.rewritten.getSql(), this.getContext()) : this.statementBuilder.create(this.handle.getConnection(), this.rewritten.getSql(), this.getContext());
        }
        catch (SQLException e) {
            throw new UnableToCreateStatementException(e, this.getContext());
        }
        this.addCleanable(new Cleanables.StatementBuilderCleanable(this.statementBuilder, this.handle.getConnection(), this.sql, this.stmt));
        this.getConcreteContext().setStatement(this.stmt);
        try {
            this.rewritten.bind(this.getParameters(), this.stmt);
        }
        catch (SQLException e) {
            throw new UnableToExecuteStatementException("Unable to bind parameters to query", e, this.getContext());
        }
        this.beforeExecution(this.stmt);
        try {
            long start = System.nanoTime();
            this.stmt.execute();
            long elapsedTime = System.nanoTime() - start;
            this.log.logSQL(elapsedTime / 1000000L, this.rewritten.getSql());
            this.timingCollector.collect(elapsedTime, this.getContext());
        }
        catch (SQLException e) {
            throw new UnableToExecuteStatementException(e, this.getContext());
        }
        this.afterExecution(this.stmt);
        try {
            return munger.munge(this.stmt);
        }
        catch (SQLException e) {
            throw new ResultSetException("Exception thrown while attempting to traverse the result set", e, this.getContext());
        }
    }

    protected SQLLog getLog() {
        return this.log;
    }

    protected TimingCollector getTimingCollector() {
        return this.timingCollector;
    }

    public void setFetchDirection(int value) {
        this.addStatementCustomizer(new StatementCustomizers.FetchDirectionStatementCustomizer(value));
    }

    public SelfType setFetchDirection2(int value) {
        this.setFetchDirection(value);
        return (SelfType)this;
    }
}

