/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.argument;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class UUIDArgumentFactory
implements ArgumentFactory<UUID> {
    @Override
    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof UUID;
    }

    @Override
    public Argument build(Class<?> expectedType, UUID value, StatementContext ctx) {
        return new UUIDArgument(value);
    }

    public class UUIDArgument
    implements Argument {
        private final UUID value;

        public UUIDArgument(UUID value) {
            this.value = value;
        }

        @Override
        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.value != null) {
                statement.setString(position, this.value.toString());
            } else {
                statement.setNull(position, 12);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UUIDArgument");
            sb.append("{value=").append(this.value);
            sb.append('}');
            return sb.toString();
        }
    }
}

