/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.mapper;

import com.google.common.base.CaseFormat;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class LowerToCamelBeanMapper<T>
implements ResultSetMapper<T> {
    private final Class<T> type;
    private final Map<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
    private final Map<String, PropertyMapper> propertiesMappers = new HashMap<String, PropertyMapper>();

    public LowerToCamelBeanMapper(Class<T> type) {
        this.type = type;
        try {
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                String key = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, descriptor.getName()).toLowerCase();
                this.properties.put(key, descriptor);
                final Class<Object> propertyType = descriptor.getPropertyType();
                PropertyMapper<ResultSet, Object> propertyMapper = propertyType.isAssignableFrom(Boolean.class) || propertyType.isAssignableFrom(Boolean.TYPE) ? new PropertyMapper<ResultSet, Boolean>(){

                    @Override
                    public Boolean apply(ResultSet rs, int i) throws SQLException {
                        return rs.getBoolean(i);
                    }
                } : (propertyType.isAssignableFrom(Byte.class) || propertyType.isAssignableFrom(Byte.TYPE) ? new PropertyMapper<ResultSet, Byte>(){

                    @Override
                    public Byte apply(ResultSet rs, int i) throws SQLException {
                        return rs.getByte(i);
                    }
                } : (propertyType.isAssignableFrom(Short.class) || propertyType.isAssignableFrom(Short.TYPE) ? new PropertyMapper<ResultSet, Short>(){

                    @Override
                    public Short apply(ResultSet rs, int i) throws SQLException {
                        return rs.getShort(i);
                    }
                } : (propertyType.isAssignableFrom(Integer.class) || propertyType.isAssignableFrom(Integer.TYPE) ? new PropertyMapper<ResultSet, Integer>(){

                    @Override
                    public Integer apply(ResultSet rs, int i) throws SQLException {
                        return rs.getInt(i);
                    }
                } : (propertyType.isAssignableFrom(Long.class) || propertyType.isAssignableFrom(Long.TYPE) ? new PropertyMapper<ResultSet, Long>(){

                    @Override
                    public Long apply(ResultSet rs, int i) throws SQLException {
                        return rs.getLong(i);
                    }
                } : (propertyType.isAssignableFrom(Float.class) || propertyType.isAssignableFrom(Float.TYPE) ? new PropertyMapper<ResultSet, Float>(){

                    @Override
                    public Float apply(ResultSet rs, int i) throws SQLException {
                        return Float.valueOf(rs.getFloat(i));
                    }
                } : (propertyType.isAssignableFrom(Double.class) || propertyType.isAssignableFrom(Double.TYPE) ? new PropertyMapper<ResultSet, Double>(){

                    @Override
                    public Double apply(ResultSet rs, int i) throws SQLException {
                        return rs.getDouble(i);
                    }
                } : (propertyType.isAssignableFrom(BigDecimal.class) ? new PropertyMapper<ResultSet, BigDecimal>(){

                    @Override
                    public BigDecimal apply(ResultSet rs, int i) throws SQLException {
                        return rs.getBigDecimal(i);
                    }
                } : (propertyType.isAssignableFrom(DateTime.class) ? new PropertyMapper<ResultSet, DateTime>(){

                    @Override
                    public DateTime apply(ResultSet rs, int i) throws SQLException {
                        Timestamp timestamp = rs.getTimestamp(i);
                        return timestamp == null ? null : new DateTime((Object)timestamp).toDateTime(DateTimeZone.UTC);
                    }
                } : (propertyType.isAssignableFrom(Time.class) ? new PropertyMapper<ResultSet, Time>(){

                    @Override
                    public Time apply(ResultSet rs, int i) throws SQLException {
                        return rs.getTime(i);
                    }
                } : (propertyType.isAssignableFrom(LocalDate.class) ? new PropertyMapper<ResultSet, LocalDate>(){

                    @Override
                    public LocalDate apply(ResultSet rs, int i) throws SQLException {
                        String dateString = rs.getString(i);
                        return dateString == null ? null : new LocalDate((Object)dateString, DateTimeZone.UTC);
                    }
                } : (propertyType.isAssignableFrom(DateTimeZone.class) ? new PropertyMapper<ResultSet, DateTimeZone>(){

                    @Override
                    public DateTimeZone apply(ResultSet rs, int i) throws SQLException {
                        String dateTimeZoneString = rs.getString(i);
                        return dateTimeZoneString == null ? null : DateTimeZone.forID((String)dateTimeZoneString);
                    }
                } : (propertyType.isAssignableFrom(String.class) ? new PropertyMapper<ResultSet, String>(){

                    @Override
                    public String apply(ResultSet rs, int i) throws SQLException {
                        return rs.getString(i);
                    }
                } : (propertyType.isAssignableFrom(UUID.class) ? new PropertyMapper<ResultSet, UUID>(){

                    @Override
                    public UUID apply(ResultSet rs, int i) throws SQLException {
                        String uuidString = rs.getString(i);
                        return uuidString == null ? null : UUID.fromString(uuidString);
                    }
                } : (propertyType.isEnum() ? new PropertyMapper<ResultSet, Enum>(){

                    @Override
                    public Enum apply(ResultSet rs, int i) throws SQLException {
                        String enumString = rs.getString(i);
                        return enumString == null ? null : (Enum)Enum.valueOf(propertyType, enumString);
                    }
                } : (propertyType == byte[].class ? new PropertyMapper<ResultSet, byte[]>(){

                    @Override
                    public byte[] apply(ResultSet rs, int i) throws SQLException {
                        return rs.getBytes(i);
                    }
                } : new PropertyMapper<ResultSet, Time>(){

                    @Override
                    public Time apply(ResultSet rs, int i) throws SQLException {
                        return (Time)rs.getObject(i);
                    }
                })))))))))))))));
                this.propertiesMappers.put(key, propertyMapper);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return LowerToCamelBeanMapper.getField(superClass, fieldName);
        }
    }

    @Override
    public T map(int row, ResultSet rs, StatementContext ctx) throws SQLException {
        T bean;
        try {
            bean = this.type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("A bean, %s, was mapped which was not instantiable", this.type.getName()), e);
        }
        Class<?> beanClass = bean.getClass();
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String name = metadata.getColumnLabel(i).toLowerCase();
            PropertyMapper propertyMapper = this.propertiesMappers.get(name);
            if (propertyMapper == null) continue;
            Object value = propertyMapper.apply(rs, i);
            if (value instanceof Blob) {
                Blob blob = (Blob)value;
                value = blob.getBytes(0L, (int)blob.length());
            }
            if (rs.wasNull() && !this.type.isPrimitive()) {
                value = null;
            }
            try {
                PropertyDescriptor descriptor = this.properties.get(name);
                Method writeMethod = descriptor.getWriteMethod();
                if (writeMethod != null) {
                    writeMethod.invoke(bean, value);
                    continue;
                }
                String camelCasedName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
                Field field = LowerToCamelBeanMapper.getField(beanClass, camelCasedName);
                field.setAccessible(true);
                field.set(bean, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Unable to set field for property: name=%s, value=%s", name, value), e);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(String.format("Unable to find field for property, %s", name), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Unable to access setter for property, %s", name), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Invocation target exception trying to invoker setter for the %s property", name), e);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException(String.format("No appropriate method to write value %s ", value), e);
            }
        }
        return bean;
    }

    protected static interface PropertyMapper<ResultSet, T> {
        public T apply(ResultSet var1, int var2) throws SQLException;
    }
}

