/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.CallableStatementMapper;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.ContainerFactoryRegistry;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.OutParameters;
import org.skife.jdbi.v2.QueryResultMunger;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementBuilder;
import org.skife.jdbi.v2.tweak.StatementCustomizer;
import org.skife.jdbi.v2.tweak.StatementLocator;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public class Call
extends SQLStatement<Call> {
    private final List<OutParamArgument> params = new ArrayList<OutParamArgument>();

    Call(Handle handle, StatementLocator locator, StatementRewriter rewriter, StatementBuilder cache, String sql, ConcreteStatementContext ctx, SQLLog log, TimingCollector timingCollector, Collection<StatementCustomizer> customizers, Foreman foreman, ContainerFactoryRegistry containerFactoryRegistry) {
        super(new Binding(), locator, rewriter, handle, cache, sql, ctx, log, timingCollector, customizers, foreman, containerFactoryRegistry);
    }

    public Call registerOutParameter(int position, int sqlType) {
        return this.registerOutParameter(position, sqlType, null);
    }

    public Call registerOutParameter(int position, int sqlType, CallableStatementMapper mapper) {
        this.getParams().addPositional(position, new OutParamArgument(sqlType, mapper, null));
        return this;
    }

    public Call registerOutParameter(String name, int sqlType) {
        return this.registerOutParameter(name, sqlType, null);
    }

    public Call registerOutParameter(String name, int sqlType, CallableStatementMapper mapper) {
        this.getParams().addNamed(name, new OutParamArgument(sqlType, mapper, name));
        return this;
    }

    public OutParameters invoke() {
        try {
            OutParameters outParameters = this.internalExecute(new QueryResultMunger<OutParameters>(){

                @Override
                public OutParameters munge(Statement results) throws SQLException {
                    OutParameters out = new OutParameters();
                    for (OutParamArgument param : Call.this.params) {
                        Object obj = param.map((CallableStatement)results);
                        out.getMap().put(param.position, obj);
                        if (param.name == null) continue;
                        out.getMap().put(param.name, obj);
                    }
                    return out;
                }
            }, null);
            return outParameters;
        }
        finally {
            this.cleanup();
        }
    }

    private class OutParamArgument
    implements Argument {
        private final int sqlType;
        private final CallableStatementMapper mapper;
        private final String name;
        private int position;

        public OutParamArgument(int sqlType, CallableStatementMapper mapper, String name) {
            this.sqlType = sqlType;
            this.mapper = mapper;
            this.name = name;
            Call.this.params.add(this);
        }

        @Override
        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            ((CallableStatement)statement).registerOutParameter(position, this.sqlType);
            this.position = position;
        }

        public Object map(CallableStatement stmt) throws SQLException {
            if (this.mapper != null) {
                return this.mapper.map(this.position, stmt);
            }
            switch (this.sqlType) {
                case -16: 
                case -9: 
                case -1: 
                case 12: 
                case 2005: 
                case 2011: {
                    return stmt.getString(this.position);
                }
                case -3: 
                case 2004: {
                    return stmt.getBytes(this.position);
                }
                case 5: {
                    return stmt.getShort(this.position);
                }
                case 4: {
                    return stmt.getInt(this.position);
                }
                case -5: {
                    return stmt.getLong(this.position);
                }
                case 92: 
                case 93: {
                    return stmt.getTimestamp(this.position);
                }
                case 91: {
                    return stmt.getDate(this.position);
                }
                case 6: {
                    return Float.valueOf(stmt.getFloat(this.position));
                }
                case 3: 
                case 8: {
                    return stmt.getDouble(this.position);
                }
            }
            return stmt.getObject(this.position);
        }
    }
}

