/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.NoOp;

class CGLIBDispatchBuilder {
    private final SortedMap<Method, Callback> callmap;
    private final Callback defalt;
    private static final Comparator<Method> MC = new Comparator<Method>(){

        @Override
        public int compare(Method left, Method right) {
            return left.toString().compareTo(right.toString());
        }
    };

    private CGLIBDispatchBuilder(Callback defalt, SortedMap<Method, Callback> callmap) {
        this.callmap = callmap;
        this.defalt = defalt;
    }

    public static CGLIBDispatchBuilder create() {
        return new CGLIBDispatchBuilder((Callback)NoOp.INSTANCE, new TreeMap<Method, Callback>(MC));
    }

    public CGLIBDispatchBuilder withDefault(Callback defalt) {
        return new CGLIBDispatchBuilder(defalt, this.callmap);
    }

    public CGLIBDispatchBuilder addCallbacks(Map<Method, Callback> additions) {
        TreeMap<Method, Callback> newmap = new TreeMap<Method, Callback>(MC);
        newmap.putAll(this.callmap);
        newmap.putAll(additions);
        return new CGLIBDispatchBuilder(this.defalt, newmap);
    }

    public CGLIBDispatchBuilder addCallback(Method method, Callback callback) {
        TreeMap<Method, Callback> newmap = new TreeMap<Method, Callback>(MC);
        newmap.putAll(this.callmap);
        newmap.put(method, callback);
        return new CGLIBDispatchBuilder(this.defalt, newmap);
    }

    public Callback[] getCallbacks() {
        Callback[] callbacks = new Callback[this.callmap.size() + 1];
        callbacks[this.callmap.size()] = this.defalt;
        int idx = 0;
        for (Callback callback : this.callmap.values()) {
            callbacks[idx++] = callback;
        }
        return callbacks;
    }

    public CallbackFilter getFilter() {
        LinkedHashMap<Method, Integer> indices = new LinkedHashMap<Method, Integer>();
        int idx = 0;
        for (Method method : this.callmap.keySet()) {
            indices.put(method, idx++);
        }
        int defalt_idx = idx;
        return new MyCallbackFilter(indices, defalt_idx);
    }

    private static class MyCallbackFilter
    implements CallbackFilter {
        private final Map<Method, Integer> indices;
        private final int defalt_idx;

        public MyCallbackFilter(Map<Method, Integer> indices, int defalt_idx) {
            this.indices = indices;
            this.defalt_idx = defalt_idx;
        }

        public int accept(Method method) {
            if (this.indices.containsKey(method)) {
                return this.indices.get(method);
            }
            return this.defalt_idx;
        }

        public int hashCode() {
            return this.indices.hashCode() + this.defalt_idx;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MyCallbackFilter)) {
                return false;
            }
            MyCallbackFilter other = (MyCallbackFilter)o;
            return this.indices.equals(other.indices) && this.defalt_idx == other.defalt_idx;
        }
    }
}

