/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.stringtemplate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.StatementLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.STMessage;

public class ST4StatementLocator
implements StatementLocator {
    private static final Logger logger = LoggerFactory.getLogger(ST4StatementLocator.class);
    private static final ErrorManager ERROR_MANAGER = new ErrorManager((STErrorListener)new SLF4JSTErrorListener());
    private static final Map<String, STGroup> CACHE = new ConcurrentHashMap<String, STGroup>();
    private static final String COMPOSITE_KEY_SEPARATOR = "___#___";
    @VisibleForTesting
    final Map<String, String> locatedSqlCache = new ConcurrentHashMap<String, String>();
    private final STGroup group;

    public ST4StatementLocator(STGroup group) {
        this.group = group;
    }

    public static StatementLocator fromClasspath(String path) {
        return ST4StatementLocator.fromClasspath(UseSTGroupCache.YES, path);
    }

    public static StatementLocator fromClasspath(UseSTGroupCache useCache, String path) {
        return ST4StatementLocator.forURL(useCache, ST4StatementLocator.class.getResource(path));
    }

    public static StatementLocator forType(Class sqlObjectType) {
        return ST4StatementLocator.forType(UseSTGroupCache.YES, sqlObjectType);
    }

    public static StatementLocator forType(UseSTGroupCache useCache, Class sqlObjectType) {
        return ST4StatementLocator.forURL(useCache, ST4StatementLocator.classToUrl(sqlObjectType));
    }

    public static StatementLocator forURL(UseSTGroupCache useCache, URL url) {
        STGroup stg = useCache == UseSTGroupCache.YES ? ST4StatementLocator.computeIfAbsent(CACHE, url.toString(), new Function<String, STGroup>(){

            public STGroup apply(String u) {
                return u == null ? null : ST4StatementLocator.urlToSTGroup(u);
            }
        }) : ST4StatementLocator.urlToSTGroup(url.toString());
        return new ST4StatementLocator(stg);
    }

    public static StatementLocator perType(UseSTGroupCache useCache) {
        return ST4StatementLocator.perType(useCache, new STGroup('<', '>'));
    }

    public static StatementLocator perType(UseSTGroupCache useCache, String fallbackTemplateGroupPath) {
        return ST4StatementLocator.perType(useCache, ST4StatementLocator.class.getResource(fallbackTemplateGroupPath));
    }

    public static StatementLocator perType(UseSTGroupCache useCache, URL baseTemplate) {
        return ST4StatementLocator.perType(useCache, ST4StatementLocator.urlToSTGroup(baseTemplate));
    }

    public static StatementLocator perType(final UseSTGroupCache useCache, STGroup fallbackTemplateGroup) {
        final ST4StatementLocator fallback = new ST4StatementLocator(fallbackTemplateGroup);
        if (useCache == UseSTGroupCache.YES) {
            final ConcurrentHashMap sqlObjectCache = new ConcurrentHashMap();
            return new StatementLocator(){

                @Override
                public String locate(String name, final StatementContext ctx) throws Exception {
                    if (ctx.getSqlObjectType() != null) {
                        StatementLocator sl = (StatementLocator)ST4StatementLocator.computeIfAbsent(sqlObjectCache, ctx.getSqlObjectType(), new Function<Class<?>, StatementLocator>(){

                            public StatementLocator apply(Class<?> c) {
                                return ST4StatementLocator.forType(useCache, ctx.getSqlObjectType());
                            }
                        });
                        return sl.locate(name, ctx);
                    }
                    return fallback.locate(name, ctx);
                }
            };
        }
        return new StatementLocator(){

            @Override
            public String locate(String name, StatementContext ctx) throws Exception {
                if (ctx.getSqlObjectType() != null) {
                    return ST4StatementLocator.forType(useCache, ctx.getSqlObjectType()).locate(name, ctx);
                }
                return fallback.locate(name, ctx);
            }
        };
    }

    private static URL classToUrl(Class c) {
        String fullName = c.getName();
        String pkg = c.getPackage().getName();
        String className = fullName.substring(pkg.length() + 1, fullName.length()).replace('$', '.');
        return c.getResource(className + ".sql.stg");
    }

    private static STGroup urlToSTGroup(String u) {
        try {
            return ST4StatementLocator.urlToSTGroup(new URL(u));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("a URL failed to roundtrip from a string!", e);
        }
    }

    private static STGroup urlToSTGroup(URL u) {
        return new STGroupFileWithThreadSafeLoading(u, "UTF-8", '<', '>');
    }

    private static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<K, V> mappingFunction) {
        Object newValue;
        Object v = map.get(key);
        if (v == null && (newValue = mappingFunction.apply(key)) != null) {
            v = ST4StatementLocator.putIfAbsent(map, key, newValue);
            if (v == null) {
                return (V)newValue;
            }
            return v;
        }
        return v;
    }

    private static <K, V> V putIfAbsent(Map<K, V> map, K key, V value) {
        V v = map.get(key);
        if (v == null) {
            v = map.put(key, value);
        }
        return v;
    }

    @Override
    public String locate(String name, StatementContext ctx) throws Exception {
        Iterator<Map.Entry<String, Object>> entryIterator = ctx.getAttributes().entrySet().iterator();
        if (!entryIterator.hasNext()) {
            return this.locateFromCache(name, name, ctx);
        }
        Map.Entry<String, Object> attribute1 = entryIterator.next();
        if (!entryIterator.hasNext()) {
            String compositeKey = this.buildCompositeCacheKey(name, attribute1);
            return this.locateFromCache(compositeKey, name, ctx);
        }
        Map.Entry<String, Object> attribute2 = entryIterator.next();
        if (!entryIterator.hasNext()) {
            String compositeKey = this.buildCompositeCacheKey(name, attribute1, attribute2);
            return this.locateFromCache(compositeKey, name, ctx);
        }
        return this.locateAndRender(name, ctx);
    }

    private String buildCompositeCacheKey(String name, Map.Entry<String, Object> attribute) {
        return name + COMPOSITE_KEY_SEPARATOR + attribute.getKey() + COMPOSITE_KEY_SEPARATOR + attribute.getValue();
    }

    private String buildCompositeCacheKey(String name, Map.Entry<String, Object> attribute1, Map.Entry<String, Object> attribute2) {
        if (attribute1.getKey().compareTo(attribute2.getKey()) <= 0) {
            return name + COMPOSITE_KEY_SEPARATOR + attribute1.getKey() + COMPOSITE_KEY_SEPARATOR + attribute1.getValue() + COMPOSITE_KEY_SEPARATOR + attribute2.getKey() + COMPOSITE_KEY_SEPARATOR + attribute2.getValue();
        }
        return name + COMPOSITE_KEY_SEPARATOR + attribute2.getKey() + COMPOSITE_KEY_SEPARATOR + attribute2.getValue() + COMPOSITE_KEY_SEPARATOR + attribute1.getKey() + COMPOSITE_KEY_SEPARATOR + attribute1.getValue();
    }

    private String locateFromCache(String cacheKey, String name, StatementContext ctx) {
        String locatedSql = this.locatedSqlCache.get(cacheKey);
        if (locatedSql != null) {
            return locatedSql;
        }
        locatedSql = this.locateAndRender(name, ctx);
        if (this.locatedSqlCache.size() < 500) {
            this.locatedSqlCache.put(cacheKey, locatedSql);
        }
        return locatedSql;
    }

    private String locateAndRender(String name, StatementContext ctx) {
        ST st = this.group.getInstanceOf(name);
        if (st == null) {
            st = new ST(name);
        }
        st.impl.hasFormalArgs = false;
        st.impl.nativeGroup.errMgr = ERROR_MANAGER;
        for (Map.Entry<String, Object> attr : ctx.getAttributes().entrySet()) {
            st.add(attr.getKey(), attr.getValue());
        }
        return st.render();
    }

    private static final class SLF4JSTErrorListener
    implements STErrorListener {
        private SLF4JSTErrorListener() {
        }

        public void compileTimeError(STMessage msg) {
            if (msg != null) {
                logger.warn(msg.toString());
            }
        }

        public void runTimeError(STMessage msg) {
            if (msg != null) {
                logger.warn(msg.toString());
            }
        }

        public void IOError(STMessage msg) {
            if (msg != null) {
                logger.warn(msg.toString());
            }
        }

        public void internalError(STMessage msg) {
            if (msg != null) {
                logger.warn(msg.toString());
            }
        }
    }

    private static final class STGroupFileWithThreadSafeLoading
    extends STGroupFile {
        public STGroupFileWithThreadSafeLoading(URL url, String encoding, char delimiterStartChar, char delimiterStopChar) {
            super(url, encoding, delimiterStartChar, delimiterStopChar);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompiledST lookupTemplate(String name) {
            ClassLoader initialContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (initialContextClassLoader == null) {
                    Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                }
                CompiledST compiledST = this.lookupTemplateInternal(name);
                return compiledST;
            }
            finally {
                Thread.currentThread().setContextClassLoader(initialContextClassLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CompiledST lookupTemplateInternal(String name) {
            STGroupFileWithThreadSafeLoading sTGroupFileWithThreadSafeLoading;
            CompiledST code;
            if (name.charAt(0) != '/') {
                name = "/" + name;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}.lookupTemplate({})", (Object)this.getName(), (Object)name);
            }
            if ((code = this.rawGetTemplate(name)) == NOT_FOUND_ST) {
                logger.debug("{} previously seen as not found", (Object)name);
                return null;
            }
            if (code == null) {
                sTGroupFileWithThreadSafeLoading = this;
                synchronized (sTGroupFileWithThreadSafeLoading) {
                    code = this.rawGetTemplate(name);
                    if (code == null) {
                        code = this.load(name);
                    }
                }
            }
            if (code == null) {
                sTGroupFileWithThreadSafeLoading = this;
                synchronized (sTGroupFileWithThreadSafeLoading) {
                    code = this.rawGetTemplate(name);
                    if (code == null) {
                        code = this.lookupImportedTemplate(name);
                    }
                }
            }
            if (code == null) {
                logger.debug("{} recorded not found", (Object)name);
                this.templates.put(name, NOT_FOUND_ST);
            }
            if (code != null && logger.isDebugEnabled()) {
                logger.debug("{}.lookupTemplate({}) found", (Object)this.getName(), (Object)name);
            }
            return code;
        }
    }

    public static enum UseSTGroupCache {
        YES,
        NO;

    }
}

