/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.hikari;

import com.zaxxer.hikari.HikariConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.killbill.commons.health.api.HealthCheck;
import org.killbill.commons.health.api.HealthCheckRegistry;
import org.killbill.commons.health.api.Result;
import org.killbill.commons.health.impl.HealthyResult;
import org.killbill.commons.health.impl.HealthyResultBuilder;
import org.killbill.commons.health.impl.UnhealthyResultBuilder;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.Timer;

public final class KillBillHealthChecker {
    private KillBillHealthChecker() {
    }

    public static void registerHealthChecks(DataSource dataSource, HikariConfig hikariConfig, HealthCheckRegistry registry) {
        Properties healthCheckProperties = hikariConfig.getHealthCheckProperties();
        MetricRegistry metricRegistry = (MetricRegistry)hikariConfig.getMetricRegistry();
        registry.register(String.format("%s.%s.%s", hikariConfig.getPoolName(), "pool", "ConnectivityCheck"), (HealthCheck)new ConnectivityHealthCheck(dataSource));
        long expected99thPercentile = Long.parseLong(healthCheckProperties.getProperty("expected99thPercentileMs", "0"));
        if (metricRegistry != null && expected99thPercentile > 0L) {
            for (Map.Entry entry : metricRegistry.getTimers().entrySet()) {
                if (!((String)entry.getKey()).equals(String.format("%s.%s.%s", hikariConfig.getPoolName(), "pool", "Wait"))) continue;
                registry.register(String.format("%s.%s.%s", hikariConfig.getPoolName(), "pool", "Connection99Percent"), (HealthCheck)new Connection99Percent((Timer)entry.getValue(), expected99thPercentile));
            }
        }
    }

    private static class Connection99Percent
    implements HealthCheck {
        private final Timer waitTimer;
        private final long expected99thPercentile;

        Connection99Percent(Timer waitTimer, long expected99thPercentile) {
            this.waitTimer = waitTimer;
            this.expected99thPercentile = expected99thPercentile;
        }

        public Result check() throws Exception {
            long the99thPercentile = TimeUnit.NANOSECONDS.toMillis(Math.round(this.waitTimer.getSnapshot().get99thPercentile()));
            return the99thPercentile <= this.expected99thPercentile ? new HealthyResultBuilder().createHealthyResult() : new UnhealthyResultBuilder().setMessage(String.format("99th percentile connection wait time of %dms exceeds the threshold %dms", the99thPercentile, this.expected99thPercentile)).createUnhealthyResult();
        }
    }

    private static class ConnectivityHealthCheck
    implements HealthCheck {
        private final DataSource dataSource;

        ConnectivityHealthCheck(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Result check() throws Exception {
            HealthyResult healthyResult;
            block8: {
                Connection ignored = this.dataSource.getConnection();
                try {
                    healthyResult = new HealthyResultBuilder().createHealthyResult();
                    if (ignored == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        return new UnhealthyResultBuilder().setError((Throwable)e).createUnhealthyResult();
                    }
                }
                ignored.close();
            }
            return healthyResult;
        }
    }
}

