/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import com.fasterxml.classmate.members.ResolvedMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.skife.jdbi.v2.GeneratedKeys;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.sqlobject.CustomizingStatementHandler;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.ResultReturnThing;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlObject;
import org.skife.jdbi.v2.sqlobject.customizers.BatchChunkSize;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

class BatchHandler
extends CustomizingStatementHandler {
    private final String sql;
    private final boolean transactional;
    private final ChunkSizeFunction batchChunkSize;
    private final Returner returner;

    BatchHandler(Class<?> sqlObjectType, ResolvedMethod method) {
        super(sqlObjectType, method);
        Method raw_method = (Method)method.getRawMember();
        SqlBatch anno = raw_method.getAnnotation(SqlBatch.class);
        this.sql = SqlObject.getSql(anno, raw_method);
        this.transactional = anno.transactional();
        this.batchChunkSize = this.determineBatchChunkSize(sqlObjectType, raw_method);
        final GetGeneratedKeys getGeneratedKeys = raw_method.getAnnotation(GetGeneratedKeys.class);
        if (getGeneratedKeys == null) {
            if (!BatchHandler.returnTypeIsValid(((Method)method.getRawMember()).getReturnType())) {
                throw new DBIException(BatchHandler.invalidReturnTypeMessage(method)){};
            }
            this.returner = new Returner(){

                @Override
                public Object value(PreparedBatch batch, HandleDing baton) {
                    return batch.execute();
                }
            };
        } else {
            ResultSetMapper mapper;
            try {
                mapper = getGeneratedKeys.value().newInstance();
            }
            catch (Exception e) {
                throw new UnableToCreateStatementException("Unable to instantiate result set mapper for statement", e);
            }
            final ResultReturnThing magic = ResultReturnThing.forType(method);
            this.returner = getGeneratedKeys.columnName().isEmpty() ? new Returner(){

                @Override
                public Object value(PreparedBatch batch, HandleDing baton) {
                    GeneratedKeys o = batch.executeAndGenerateKeys(mapper, new String[0]);
                    return magic.result(o, baton);
                }
            } : new Returner(){

                @Override
                public Object value(PreparedBatch batch, HandleDing baton) {
                    String columnName = getGeneratedKeys.columnName();
                    GeneratedKeys o = batch.executeAndGenerateKeys(mapper, columnName);
                    return magic.result(o, baton);
                }
            };
        }
    }

    private ChunkSizeFunction determineBatchChunkSize(Class<?> sqlObjectType, Method raw_method) {
        int index_of_batch_chunk_size_annotation_on_parameter = this.findBatchChunkSizeFromParam(raw_method);
        if (index_of_batch_chunk_size_annotation_on_parameter >= 0) {
            return new ParamBasedChunkSizeFunction(index_of_batch_chunk_size_annotation_on_parameter);
        }
        if (raw_method.isAnnotationPresent(BatchChunkSize.class)) {
            int size = raw_method.getAnnotation(BatchChunkSize.class).value();
            if (size <= 0) {
                throw new IllegalArgumentException("Batch chunk size must be >= 0");
            }
            return new ConstantChunkSizeFunction(size);
        }
        if (sqlObjectType.isAnnotationPresent(BatchChunkSize.class)) {
            int size = ((BatchChunkSize)BatchChunkSize.class.cast(sqlObjectType.getAnnotation(BatchChunkSize.class))).value();
            return new ConstantChunkSizeFunction(size);
        }
        return new ConstantChunkSizeFunction(Integer.MAX_VALUE);
    }

    private int findBatchChunkSizeFromParam(Method raw_method) {
        Annotation[][] param_annos = raw_method.getParameterAnnotations();
        for (int i = 0; i < param_annos.length; ++i) {
            Annotation[] annos;
            for (Annotation anno : annos = param_annos[i]) {
                if (!anno.annotationType().isAssignableFrom(BatchChunkSize.class)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object invoke(HandleDing h, Object target, Object[] args, Callable<?> methodProxy) {
        Object[] _args;
        boolean foundIterator = false;
        Handle handle = h.getHandle();
        ArrayList<Iterator> extras = new ArrayList<Iterator>();
        for (final Object arg : args) {
            if (arg instanceof Iterable) {
                extras.add(((Iterable)arg).iterator());
                foundIterator = true;
                continue;
            }
            if (arg instanceof Iterator) {
                extras.add((Iterator)arg);
                foundIterator = true;
                continue;
            }
            if (arg.getClass().isArray()) {
                extras.add(Arrays.asList((Object[])arg).iterator());
                foundIterator = true;
                continue;
            }
            extras.add(new Iterator(){

                @Override
                public boolean hasNext() {
                    return true;
                }

                public Object next() {
                    return arg;
                }

                @Override
                public void remove() {
                }
            });
        }
        if (!foundIterator) {
            throw new UnableToExecuteStatementException("@SqlBatch must have at least one iterable parameter", (StatementContext)null);
        }
        int processed = 0;
        LinkedList<Object> results = new LinkedList<Object>();
        PreparedBatch batch = handle.prepareBatch(this.sql);
        this.applyCustomizers(batch, args);
        int chunk_size = this.batchChunkSize.call(args);
        while ((_args = BatchHandler.next(extras)) != null) {
            PreparedBatchPart part = batch.add();
            this.applyBinders(part, _args);
            if (++processed != chunk_size) continue;
            processed = 0;
            this.executeBatch(results, h, handle, batch);
            batch = handle.prepareBatch(this.sql);
            this.applyCustomizers(batch, args);
        }
        if (batch.getSize() > 0) {
            this.executeBatch(results, h, handle, batch);
        }
        return results;
    }

    private void executeBatch(Collection<Object> results, HandleDing h, Handle handle, PreparedBatch batch) {
        Object res = this.executeBatch(h, handle, batch);
        if (res instanceof Collection) {
            results.addAll((Collection)res);
        } else {
            results.add(res);
        }
    }

    private Object executeBatch(final HandleDing h, Handle handle, final PreparedBatch batch) {
        if (!handle.isInTransaction() && this.transactional) {
            return handle.inTransaction(new TransactionCallback<Object>(){

                @Override
                public Object inTransaction(Handle conn, TransactionStatus status) throws Exception {
                    return BatchHandler.this.returner.value(batch, h);
                }
            });
        }
        return this.returner.value(batch, h);
    }

    private static Object[] next(List<Iterator> args) {
        ArrayList rs = new ArrayList();
        for (Iterator arg : args) {
            if (arg.hasNext()) {
                rs.add(arg.next());
                continue;
            }
            return null;
        }
        return rs.toArray();
    }

    private static boolean returnTypeIsValid(Class<?> type) {
        return type.equals(Void.TYPE) || type.isArray() && type.getComponentType().equals(Integer.TYPE);
    }

    private static String invalidReturnTypeMessage(ResolvedMethod method) {
        return method.getDeclaringType() + "." + method + " method is annotated with @SqlBatch so should return void or int[] but is returning: " + method.getReturnType();
    }

    private static class ParamBasedChunkSizeFunction
    implements ChunkSizeFunction {
        private final int index;

        ParamBasedChunkSizeFunction(int index) {
            this.index = index;
        }

        @Override
        public int call(Object[] args) {
            return (Integer)args[this.index];
        }
    }

    private static class ConstantChunkSizeFunction
    implements ChunkSizeFunction {
        private final int value;

        ConstantChunkSizeFunction(int value) {
            this.value = value;
        }

        @Override
        public int call(Object[] args) {
            return this.value;
        }
    }

    private static interface ChunkSizeFunction {
        public int call(Object[] var1);
    }

    private static interface Returner {
        public Object value(PreparedBatch var1, HandleDing var2);
    }
}

