/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.guice;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.killbill.commons.jdbi.argument.DateTimeArgumentFactory;
import org.killbill.commons.jdbi.argument.DateTimeZoneArgumentFactory;
import org.killbill.commons.jdbi.argument.LocalDateArgumentFactory;
import org.killbill.commons.jdbi.argument.UUIDArgumentFactory;
import org.killbill.commons.jdbi.guice.DaoConfig;
import org.killbill.commons.jdbi.log.Slf4jLogging;
import org.killbill.commons.jdbi.mapper.UUIDMapper;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementBuilderFactory;
import org.skife.jdbi.v2.tweak.StatementRewriter;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBIProvider
implements Provider<IDBI> {
    private static final Logger logger = LoggerFactory.getLogger(DBIProvider.class);
    private final DaoConfig config;
    private final DataSource ds;
    private final TransactionHandler transactionHandler;
    private final Set<ArgumentFactory> argumentFactorySet = new LinkedHashSet<ArgumentFactory>();
    private final Set<ResultSetMapperFactory> resultSetMapperFactorySet = new LinkedHashSet<ResultSetMapperFactory>();
    private final Set<ResultSetMapper> resultSetMapperSet = new LinkedHashSet<ResultSetMapper>();
    private SQLLog sqlLog;
    private TimingCollector timingCollector;
    private StatementRewriter statementRewriter;
    private StatementBuilderFactory statementBuilderFactory;

    @Inject
    public DBIProvider(DaoConfig config, DataSource ds, TransactionHandler transactionHandler) {
        this.config = config;
        this.ds = ds;
        this.transactionHandler = transactionHandler;
        this.setDefaultArgumentFactorySet();
        this.setDefaultResultSetMapperSet();
    }

    @Inject
    public void setArgumentFactorySet(@Nullable Set<ArgumentFactory> argumentFactorySet) {
        if (argumentFactorySet != null) {
            this.argumentFactorySet.addAll(argumentFactorySet);
        }
    }

    @Inject
    public void setResultSetMapperFactorySet(@Nullable Set<ResultSetMapperFactory> resultSetMapperFactorySet) {
        if (resultSetMapperFactorySet != null) {
            this.resultSetMapperFactorySet.addAll(resultSetMapperFactorySet);
        }
    }

    @Inject
    public void setResultSetMapperSet(@Nullable Set<ResultSetMapper> resultSetMapperSet) {
        if (resultSetMapperSet != null) {
            this.resultSetMapperSet.addAll(resultSetMapperSet);
        }
    }

    @Inject
    public void setSqlLog(@Nullable SQLLog sqlLog) {
        this.sqlLog = sqlLog;
    }

    @Inject
    public void setTimingCollector(@Nullable TimingCollector timingCollector) {
        this.timingCollector = timingCollector;
    }

    @Inject
    public void setStatementRewriter(@Nullable StatementRewriter statementRewriter) {
        this.statementRewriter = statementRewriter;
    }

    @Inject
    public void setStatementBuilderFactory(@Nullable StatementBuilderFactory statementBuilderFactory) {
        this.statementBuilderFactory = statementBuilderFactory;
    }

    public IDBI get() {
        DBI dbi = new DBI(this.ds);
        if (this.statementRewriter != null) {
            dbi.setStatementRewriter(this.statementRewriter);
        }
        if (this.statementBuilderFactory != null) {
            dbi.setStatementBuilderFactory(this.statementBuilderFactory);
        }
        for (ArgumentFactory argumentFactory : this.argumentFactorySet) {
            dbi.registerArgumentFactory(argumentFactory);
        }
        for (ResultSetMapperFactory resultSetMapperFactory : this.resultSetMapperFactorySet) {
            dbi.registerMapper(resultSetMapperFactory);
        }
        for (ResultSetMapper resultSetMapper : this.resultSetMapperSet) {
            dbi.registerMapper(resultSetMapper);
        }
        if (this.transactionHandler != null) {
            dbi.setTransactionHandler(this.transactionHandler);
        }
        if (this.sqlLog != null) {
            dbi.setSQLLog(this.sqlLog);
        } else if (this.config != null) {
            Slf4jLogging sqlLog = new Slf4jLogging(logger, this.config.getLogLevel());
            dbi.setSQLLog(sqlLog);
        }
        if (this.timingCollector != null) {
            dbi.setTimingCollector(this.timingCollector);
        }
        return dbi;
    }

    protected void setDefaultArgumentFactorySet() {
        this.argumentFactorySet.add(new UUIDArgumentFactory());
        this.argumentFactorySet.add(new DateTimeZoneArgumentFactory());
        this.argumentFactorySet.add(new DateTimeArgumentFactory());
        this.argumentFactorySet.add(new LocalDateArgumentFactory());
    }

    protected void setDefaultResultSetMapperSet() {
        this.resultSetMapperSet.add(new UUIDMapper());
    }
}

