/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.hikari;

import com.zaxxer.hikari.metrics.IMetricsTracker;
import com.zaxxer.hikari.metrics.PoolStats;
import java.util.concurrent.TimeUnit;
import org.killbill.commons.metrics.api.Histogram;
import org.killbill.commons.metrics.api.Meter;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.Timer;

public class KillBillMetricsTracker
implements IMetricsTracker {
    private static final String METRIC_CATEGORY = "pool";
    private static final String METRIC_NAME_WAIT = "Wait";
    private static final String METRIC_NAME_USAGE = "Usage";
    private static final String METRIC_NAME_CONNECT = "ConnectionCreation";
    private static final String METRIC_NAME_TIMEOUT_RATE = "ConnectionTimeoutRate";
    private static final String METRIC_NAME_TOTAL_CONNECTIONS = "TotalConnections";
    private static final String METRIC_NAME_IDLE_CONNECTIONS = "IdleConnections";
    private static final String METRIC_NAME_ACTIVE_CONNECTIONS = "ActiveConnections";
    private static final String METRIC_NAME_PENDING_CONNECTIONS = "PendingConnections";
    private static final String METRIC_NAME_MAX_CONNECTIONS = "MaxConnections";
    private static final String METRIC_NAME_MIN_CONNECTIONS = "MinConnections";
    private final String poolName;
    private final Timer connectionObtainTimer;
    private final Histogram connectionUsage;
    private final Histogram connectionCreation;
    private final Meter connectionTimeoutMeter;
    private final MetricRegistry registry;

    public KillBillMetricsTracker(String poolName, PoolStats poolStats, MetricRegistry registry) {
        this.poolName = poolName;
        this.registry = registry;
        this.connectionObtainTimer = registry.timer(String.format("%s.%s.%s", poolName, METRIC_CATEGORY, METRIC_NAME_WAIT));
        this.connectionUsage = registry.histogram(String.format("%s.%s.%s", poolName, METRIC_CATEGORY, METRIC_NAME_USAGE));
        this.connectionCreation = registry.histogram(String.format("%s.%s.%s", poolName, METRIC_CATEGORY, METRIC_NAME_CONNECT));
        this.connectionTimeoutMeter = registry.meter(String.format("%s.%s.%s", poolName, METRIC_CATEGORY, METRIC_NAME_TIMEOUT_RATE));
        registry.gauge(String.format("%s.%s.%s", poolName, METRIC_CATEGORY, METRIC_NAME_TOTAL_CONNECTIONS), () -> ((PoolStats)poolStats).getTotalConnections());
        registry.gauge(String.format("%s.%s.%s", poolName, METRIC_CATEGORY, METRIC_NAME_IDLE_CONNECTIONS), () -> ((PoolStats)poolStats).getIdleConnections());
        registry.gauge(String.format("%s.%s.%s", poolName, METRIC_CATEGORY, METRIC_NAME_ACTIVE_CONNECTIONS), () -> ((PoolStats)poolStats).getActiveConnections());
        registry.gauge(String.format("%s.%s.%s", poolName, METRIC_CATEGORY, METRIC_NAME_PENDING_CONNECTIONS), () -> ((PoolStats)poolStats).getPendingThreads());
        registry.gauge(String.format("%s.%s.%s", poolName, METRIC_CATEGORY, METRIC_NAME_MAX_CONNECTIONS), () -> ((PoolStats)poolStats).getMaxConnections());
        registry.gauge(String.format("%s.%s.%s", poolName, METRIC_CATEGORY, METRIC_NAME_MIN_CONNECTIONS), () -> ((PoolStats)poolStats).getMinConnections());
    }

    public void close() {
        this.registry.remove(String.format("%s.%s.%s", this.poolName, METRIC_CATEGORY, METRIC_NAME_WAIT));
        this.registry.remove(String.format("%s.%s.%s", this.poolName, METRIC_CATEGORY, METRIC_NAME_USAGE));
        this.registry.remove(String.format("%s.%s.%s", this.poolName, METRIC_CATEGORY, METRIC_NAME_CONNECT));
        this.registry.remove(String.format("%s.%s.%s", this.poolName, METRIC_CATEGORY, METRIC_NAME_TIMEOUT_RATE));
        this.registry.remove(String.format("%s.%s.%s", this.poolName, METRIC_CATEGORY, METRIC_NAME_TOTAL_CONNECTIONS));
        this.registry.remove(String.format("%s.%s.%s", this.poolName, METRIC_CATEGORY, METRIC_NAME_IDLE_CONNECTIONS));
        this.registry.remove(String.format("%s.%s.%s", this.poolName, METRIC_CATEGORY, METRIC_NAME_ACTIVE_CONNECTIONS));
        this.registry.remove(String.format("%s.%s.%s", this.poolName, METRIC_CATEGORY, METRIC_NAME_PENDING_CONNECTIONS));
        this.registry.remove(String.format("%s.%s.%s", this.poolName, METRIC_CATEGORY, METRIC_NAME_MAX_CONNECTIONS));
        this.registry.remove(String.format("%s.%s.%s", this.poolName, METRIC_CATEGORY, METRIC_NAME_MIN_CONNECTIONS));
    }

    public void recordConnectionAcquiredNanos(long elapsedAcquiredNanos) {
        this.connectionObtainTimer.update(elapsedAcquiredNanos, TimeUnit.NANOSECONDS);
    }

    public void recordConnectionUsageMillis(long elapsedBorrowedMillis) {
        this.connectionUsage.update(elapsedBorrowedMillis);
    }

    public void recordConnectionTimeout() {
        this.connectionTimeoutMeter.mark(1L);
    }

    public void recordConnectionCreatedMillis(long connectionCreatedMillis) {
        this.connectionCreation.update(connectionCreatedMillis);
    }

    public Timer getConnectionAcquisitionTimer() {
        return this.connectionObtainTimer;
    }

    public Histogram getConnectionDurationHistogram() {
        return this.connectionUsage;
    }

    public Histogram getConnectionCreationHistogram() {
        return this.connectionCreation;
    }
}

