/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.transaction;

import java.sql.SQLException;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.skife.jdbi.v2.tweak.transactions.DelegatingTransactionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartTransactionRunner
extends DelegatingTransactionHandler
implements TransactionHandler {
    private static final Logger log = LoggerFactory.getLogger(RestartTransactionRunner.class);
    private static final String SQLSTATE_TXN_SERIALIZATION_FAILED = "40001";
    private static final String SQLSTATE_INNODB_WAIT_LOCK_TIMEOUT_EXCEEDED = "41000";
    private final Configuration configuration;

    public RestartTransactionRunner(TransactionHandler delegate) {
        this(new Configuration(), delegate);
    }

    public RestartTransactionRunner(Configuration configuration, TransactionHandler delegate) {
        super(delegate);
        this.configuration = configuration;
    }

    @Override
    public <ReturnType> ReturnType inTransaction(Handle handle, TransactionCallback<ReturnType> callback) {
        int retriesRemaining = this.configuration.maxRetries;
        while (true) {
            try {
                return this.getDelegate().inTransaction(handle, callback);
            }
            catch (RuntimeException e) {
                if (!this.isSqlState(this.configuration.serializationFailureSqlStates, e) || --retriesRemaining <= 0) {
                    throw e;
                }
                if (e.getCause() instanceof SQLException) {
                    String sqlState = ((SQLException)e.getCause()).getSQLState();
                    log.warn("Restarting transaction due to SQLState {}, retries remaining {}", (Object)sqlState, (Object)retriesRemaining);
                    continue;
                }
                log.warn("Restarting transaction due to {}, retries remaining {}", (Object)e.toString(), (Object)retriesRemaining);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnType> ReturnType inTransaction(Handle handle, TransactionIsolationLevel level, TransactionCallback<ReturnType> callback) {
        TransactionIsolationLevel initial = handle.getTransactionIsolationLevel();
        try {
            handle.setTransactionIsolation(level);
            ReturnType ReturnType = this.inTransaction(handle, callback);
            return ReturnType;
        }
        finally {
            handle.setTransactionIsolation(initial);
        }
    }

    protected boolean isSqlState(String[] expectedSqlStates, Throwable throwable) {
        do {
            String sqlState;
            if (!(throwable instanceof SQLException) || (sqlState = ((SQLException)throwable).getSQLState()) == null) continue;
            for (String expectedSqlState : expectedSqlStates) {
                if (!sqlState.startsWith(expectedSqlState)) continue;
                return true;
            }
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    public static class Configuration {
        private final int maxRetries;
        private final String[] serializationFailureSqlStates;

        public Configuration() {
            this(5, new String[]{RestartTransactionRunner.SQLSTATE_TXN_SERIALIZATION_FAILED, RestartTransactionRunner.SQLSTATE_INNODB_WAIT_LOCK_TIMEOUT_EXCEEDED});
        }

        private Configuration(int maxRetries, String[] serializationFailureSqlStates) {
            this.maxRetries = maxRetries;
            this.serializationFailureSqlStates = serializationFailureSqlStates;
        }

        public Configuration withMaxRetries(int maxRetries) {
            return new Configuration(maxRetries, this.serializationFailureSqlStates);
        }

        public Configuration withSerializationFailureSqlState(String[] serializationFailureSqlState) {
            return new Configuration(this.maxRetries, serializationFailureSqlState);
        }
    }
}

