/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.Handler;
import org.skife.jdbi.v2.sqlobject.Transaction;

class PassThroughTransactionHandler
implements Handler {
    private final TransactionIsolationLevel isolation;

    PassThroughTransactionHandler(Method m, Transaction tx) {
        this.isolation = tx.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(HandleDing ding, Object target, Object[] args, final Callable<?> methodProxy) {
        ding.retain("pass-through-transaction");
        try {
            Handle h = ding.getHandle();
            if (Objects.isNull(methodProxy)) {
                throw new AbstractMethodError("Method in " + target.getClass() + " could not be invoked  -- it probably needs a @Sql* annotation of some kind.");
            }
            if (this.isolation == TransactionIsolationLevel.INVALID_LEVEL) {
                Object object = h.inTransaction(new TransactionCallback<Object>(){

                    @Override
                    public Object inTransaction(Handle conn, TransactionStatus status) throws Exception {
                        try {
                            return methodProxy.call();
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof Exception) {
                                throw (Exception)throwable;
                            }
                            throw new RuntimeException(throwable);
                        }
                    }
                });
                return object;
            }
            Object object = h.inTransaction(this.isolation, new TransactionCallback<Object>(){

                @Override
                public Object inTransaction(Handle conn, TransactionStatus status) throws Exception {
                    try {
                        return methodProxy.call();
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof Exception) {
                            throw (Exception)throwable;
                        }
                        throw new RuntimeException(throwable);
                    }
                }
            });
            return object;
        }
        finally {
            ding.release("pass-through-transaction");
        }
    }
}

