/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMethod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.skife.jdbi.v2.sqlobject.BatchHandler;
import org.skife.jdbi.v2.sqlobject.CallHandler;
import org.skife.jdbi.v2.sqlobject.CloseHandler;
import org.skife.jdbi.v2.sqlobject.CloseInternalDoNotUseThisClass;
import org.skife.jdbi.v2.sqlobject.CreateSqlObject;
import org.skife.jdbi.v2.sqlobject.CreateSqlObjectHandler;
import org.skife.jdbi.v2.sqlobject.EqualsHandler;
import org.skife.jdbi.v2.sqlobject.GetHandleHelper;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.Handler;
import org.skife.jdbi.v2.sqlobject.HashCodeHandler;
import org.skife.jdbi.v2.sqlobject.PassThroughHandler;
import org.skife.jdbi.v2.sqlobject.PassThroughTransactionHandler;
import org.skife.jdbi.v2.sqlobject.QueryHandler;
import org.skife.jdbi.v2.sqlobject.ResultReturnThing;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlCall;
import org.skife.jdbi.v2.sqlobject.SqlObjectInterceptor;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.ToStringHandler;
import org.skife.jdbi.v2.sqlobject.Transaction;
import org.skife.jdbi.v2.sqlobject.TransactionalHelper;
import org.skife.jdbi.v2.sqlobject.TransmogrifierHelper;
import org.skife.jdbi.v2.sqlobject.UpdateHandler;

class SqlObject {
    private static final TypeResolver typeResolver = new TypeResolver();
    private static final Map<Method, Handler> mixinHandlers = new HashMap<Method, Handler>();
    private static final ConcurrentMap<Class<?>, Map<Method, Handler>> handlersCache = new ConcurrentHashMap();
    private static final TypeCache<Class<?>> typeCache = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);
    private final Map<Method, Handler> handlers;
    private final HandleDing ding;
    private static final AtomicLong RETAINER;

    static <T> T buildSqlObject(Class<T> sqlObjectType, HandleDing handle) {
        T sqlObjectProxy;
        Class loadedClass = typeCache.findOrInsert(sqlObjectType.getClassLoader(), sqlObjectType, () -> new ByteBuddy().subclass(sqlObjectType).implement(new Type[]{CloseInternalDoNotUseThisClass.class}).defineField("delegateToSqlObjectInterceptor", SqlObjectInterceptor.class, new ModifierContributor.ForField[]{Visibility.PUBLIC}).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.toField((String)"delegateToSqlObjectInterceptor")).make().load(sqlObjectType.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded());
        try {
            sqlObjectProxy = sqlObjectType.cast(loadedClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError("Failed to instantiate proxy class for " + sqlObjectType.getName(), e);
        }
        SqlObject sqlObject = new SqlObject(SqlObject.buildHandlersFor(sqlObjectType), handle);
        SqlObjectInterceptor sqlObjectInterceptor = new SqlObjectInterceptor(sqlObject);
        try {
            Field sqlObjectField = sqlObjectProxy.getClass().getField("delegateToSqlObjectInterceptor");
            sqlObjectField.setAccessible(true);
            sqlObjectField.set(sqlObjectProxy, sqlObjectInterceptor);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError("Failed to delegate a method call to " + SqlObjectInterceptor.class.getName(), e);
        }
        return sqlObjectProxy;
    }

    private static Map<Method, Handler> buildHandlersFor(Class<?> sqlObjectType) {
        if (handlersCache.containsKey(sqlObjectType)) {
            return (Map)handlersCache.get(sqlObjectType);
        }
        MemberResolver mr = new MemberResolver(typeResolver);
        ResolvedType sql_object_type = typeResolver.resolve(sqlObjectType, new Type[0]);
        ResolvedTypeWithMembers d = mr.resolve(sql_object_type, null, null);
        HashMap<Method, Handler> handlers = new HashMap<Method, Handler>();
        for (ResolvedMethod method : d.getMemberMethods()) {
            Method raw_method = (Method)method.getRawMember();
            if (raw_method.isAnnotationPresent(SqlQuery.class)) {
                handlers.put(raw_method, new QueryHandler(sqlObjectType, method, ResultReturnThing.forType(method)));
                continue;
            }
            if (raw_method.isAnnotationPresent(SqlUpdate.class)) {
                handlers.put(raw_method, new UpdateHandler(sqlObjectType, method));
                continue;
            }
            if (raw_method.isAnnotationPresent(SqlBatch.class)) {
                handlers.put(raw_method, new BatchHandler(sqlObjectType, method));
                continue;
            }
            if (raw_method.isAnnotationPresent(SqlCall.class)) {
                handlers.put(raw_method, new CallHandler(sqlObjectType, method));
                continue;
            }
            if (raw_method.isAnnotationPresent(CreateSqlObject.class)) {
                handlers.put(raw_method, new CreateSqlObjectHandler(raw_method.getReturnType()));
                continue;
            }
            if (method.getName().equals("close") && ((Method)method.getRawMember()).getParameterTypes().length == 0) {
                handlers.put(raw_method, new CloseHandler());
                continue;
            }
            if (raw_method.isAnnotationPresent(Transaction.class)) {
                handlers.put(raw_method, new PassThroughTransactionHandler(raw_method, raw_method.getAnnotation(Transaction.class)));
                continue;
            }
            if (mixinHandlers.containsKey(raw_method)) {
                handlers.put(raw_method, mixinHandlers.get(raw_method));
                continue;
            }
            handlers.put(raw_method, new PassThroughHandler(raw_method));
        }
        handlers.putAll(CloseInternalDoNotUseThisClass.Helper.handlers());
        handlers.putAll(EqualsHandler.handler());
        handlers.putAll(ToStringHandler.handler(sqlObjectType.getName()));
        handlers.putAll(HashCodeHandler.handler());
        handlersCache.put(sqlObjectType, handlers);
        return handlers;
    }

    public SqlObject(Map<Method, Handler> handlers, HandleDing ding) {
        this.handlers = handlers;
        this.ding = ding;
    }

    public Object invoke(Object proxy, Method method, Object[] args, Callable<?> methodProxy) throws Throwable {
        Handler handler = this.handlers.get(method);
        if (handler == null || handler instanceof PassThroughHandler) {
            if (Objects.isNull(methodProxy)) {
                throw new AbstractMethodError("Method " + method.getDeclaringClass().getName() + "#" + method.getName() + " doesn't make sense -- it probably needs a @Sql* annotation of some kind.");
            }
            return methodProxy.call();
        }
        Throwable doNotMask = null;
        String retainName = String.valueOf(RETAINER.getAndIncrement());
        try {
            this.ding.retain(retainName);
            Object object = handler.invoke(this.ding, proxy, args, methodProxy);
            return object;
        }
        catch (Throwable e) {
            doNotMask = e;
            throw e;
        }
        finally {
            block11: {
                try {
                    this.ding.release(retainName);
                }
                catch (Throwable e) {
                    if (doNotMask != null) break block11;
                    throw e;
                }
            }
        }
    }

    public static void close(Object sqlObject) {
        if (!(sqlObject instanceof CloseInternalDoNotUseThisClass)) {
            throw new IllegalArgumentException(sqlObject + " is not a sql object");
        }
        CloseInternalDoNotUseThisClass closer = (CloseInternalDoNotUseThisClass)sqlObject;
        closer.___jdbi_close___();
    }

    static String getSql(SqlCall q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static String getSql(SqlQuery q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static String getSql(SqlUpdate q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static String getSql(SqlBatch q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static {
        mixinHandlers.putAll(TransactionalHelper.handlers());
        mixinHandlers.putAll(GetHandleHelper.handlers());
        mixinHandlers.putAll(TransmogrifierHelper.handlers());
        RETAINER = new AtomicLong();
    }
}

