/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface QueryTimeOut {
    public int value() default 0x7FFFFFFF;

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            final QueryTimeOut fs = (QueryTimeOut)annotation;
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement q) throws SQLException {
                    q.setQueryTimeout(fs.value());
                }
            };
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            final QueryTimeOut fs = (QueryTimeOut)annotation;
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement q) throws SQLException {
                    q.setQueryTimeout(fs.value());
                }
            };
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            final Integer va = (Integer)arg;
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement q) throws SQLException {
                    q.setQueryTimeout(va);
                }
            };
        }
    }
}

