/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.metrics;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.Timer;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TimingCollector;

public class KillBillTimingCollector
implements TimingCollector {
    private final MetricRegistry registry;

    public KillBillTimingCollector(MetricRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void collect(long elapsedTime, StatementContext ctx) {
        Timer timer = this.getTimer(ctx);
        timer.update(elapsedTime, TimeUnit.NANOSECONDS);
    }

    private Timer getTimer(StatementContext ctx) {
        return this.registry.timer(this.getStatementName(ctx));
    }

    private String getStatementName(StatementContext ctx) {
        String rawSql = ctx.getRawSql();
        if (rawSql == null || rawSql.isEmpty()) {
            return "sql.empty";
        }
        Class<?> clazz = ctx.getSqlObjectType();
        Method method = ctx.getSqlObjectMethod();
        if (clazz != null) {
            String group = clazz.getPackage().getName();
            String name = clazz.getSimpleName();
            String type = method == null ? rawSql : method.getName();
            return String.format("%s.%s.%s", group, name, type);
        }
        int colon = rawSql.indexOf(58);
        if (colon == -1) {
            return String.format("%s.%s.%s", "sql", "raw", rawSql);
        }
        String group = rawSql.substring(0, colon);
        String name = rawSql.substring(colon + 1);
        return String.format("%s.%s", group, name);
    }
}

